#include "TextObsVars.h"
#include "HHMMLangModel-gf.h"
#include "TextObsModel.h"
#include "HHMMParser.h"


int main (int nArgs, char* argv[]) {

  std::vector<std::string> filePaths(1);
  filePaths[0] = "/free/lane/modelblocks/wsjparse/genmodel/wsjTRAIN-pu-nr.gf-hhmm.model";

  //// I. LOAD MODELS...
  std::cerr << "Reading syntactic language model files...\n";
  // For each model file...
  for ( int a=0, n=filePaths.size(); a<n; a++ ) {                                           // read models
    FILE* pf = fopen(filePaths[a].c_str(),"r"); //assert(pf);                                   // Read model file
    if(!pf){
      std::cerr << "Error loading model file " << filePaths[a] << std::endl;
      return -1;
    }
    std::cerr << "Loading model \'" << filePaths[a] << "\'...\n";
    int c=' '; int i=0; int line=1; String sBuff(1000);                          // Lookahead/ctrs/buffers
    CONSUME_ALL ( pf, c, WHITESPACE(c), line);                                   // Get to first record
    while ( c!=-1 && c!='\0' && c!='\5' ) {                                      // For each record
      CONSUME_STR ( pf, c, (c!='\n' && c!='\0' && c!='\5'), sBuff, i, line );    //   Consume line
      StringInput si(sBuff.c_array());
      if ( !( sBuff[0]=='#'                                                   //   Accept comments/fields
			  ||  si>>*(this->hiddenModel)>>"\0"!=NULL 
			  ||  si>>*(this->observedModel)>>"\0"!=NULL
			  ))								   
	std::cerr<<"\nERROR: can't parse \'"<<sBuff<<"\' in line "<<line<<"\n\n";
      CONSUME_ALL ( pf, c, WHITESPACE(c), line);                                 //   Consume whitespace
      if ( line%100000==0 ) std::cerr<<"  "<<line<<" lines read...\n";                //   Progress for big models
    }
    std::cerr << "Model \'" << filePaths[a] << "\' loaded.\n";
    }

  std::cerr << "...reading syntactic language model files completed\n";



  /*
  LogProb l(-1270);

  cout << "logProb=\t" << l << endl;
  cout << "prob=\t" << l.toProb() << endl;
  */
  return 0;
}
