###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

#####################################################################
# smooth-srl-A-to-G.rb 
# This script smooth the srl models to the gf so as to increase the 
# recall on parsing. 
#
# The required params are: 
# srl-model-file top-significant-g-file percent-smooth-to
#
# Example:
# ruby scripts/smooth-srl-A-to-G.rb genmodel/srl-t2m.wsjpu.model genmodel/top200G .1
#
# Output is to stdout
#
# Author: Luan Nguyen	 
#
######################################################################

require "scripts/umnlp.rb"

$error = false

srlFile = ARGV[0]
topGs = ARGV[1]
percent = ARGV[2].to_f

# read the appropriate srl-all-labels file into an array
f = File.open(topGs) or die "Unable to open file #{topGs}"
allTopGs=[]  # start with an empty array
f.each_line {|line|
  if (line =~ /^#/ || /\S/ !~ line); next; end
  allTopGs.push line.strip
}

srl = File.open(srlFile) or die "Unable to open srl file #{srlFile}"
srl.each_line {|line|
  if (line =~ /^A /)
    equalSplit = line.split("= ")
    prob = "%.8f" % (equalSplit[1].to_f * (1.0 - percent))
    print equalSplit[0] + "= " + prob + "\n" 
    
    #A 3 regulate.01 ARG1 cc : ARG1 = 1
    matches = line.match(/^(.*) ([^ ]*) : ([^ ]*) = .*$/)
    prob = "%.8f" % (equalSplit[1].to_f * percent)
    allTopGs.each do |g|
      if (g != matches[2])
        print matches[1] + " " + g + " : " + matches[3] + " = " + prob + "\n"
       end
    end 
  else
    print line
  end
}



