/*
 * Decompiled with CFR 0.152.
 */
package babel.prep.corpus;

import babel.content.pages.Page;
import babel.prep.corpus.CorpusGenerator;
import babel.util.language.Language;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.lib.MultipleSequenceFileOutputFormat;

public class MultipleLangFileOutputFormat
extends MultipleSequenceFileOutputFormat<Text, Page> {
    static final Log LOG = LogFactory.getLog(MultipleLangFileOutputFormat.class);

    protected String generateFileNameForKeyValue(Text key, Page page, String name) {
        String langStr;
        Language lang = page.getLanguage();
        String string = langStr = lang == null ? "none" : lang.toString();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Language " + langStr + " for page " + page.pageURL()));
        }
        CorpusGenerator.Stats.incLangPageCount(langStr);
        return String.valueOf(langStr) + "." + super.generateFileNameForKeyValue((Object)key, (Object)page, name);
    }
}

