/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.properties.context;

import babel.content.corpora.accessors.CorpusAccessor;
import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.PhrasePropertyCollector;
import babel.content.eqclasses.properties.context.Context;
import java.io.BufferedReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PhraseContextCollector
extends PhrasePropertyCollector {
    protected static final Log LOG = LogFactory.getLog(PhraseContextCollector.class);
    protected HashMap<String, EquivalenceClass> m_allContextEqsMap;
    protected int m_leftSize;
    protected int m_rightSize;

    public PhraseContextCollector(int maxPhraseLength, boolean caseSensitive, int leftSize, int rightSize, Set<EquivalenceClass> contextEqs) throws Exception {
        super(maxPhraseLength, caseSensitive);
        this.m_leftSize = leftSize;
        this.m_rightSize = rightSize;
        this.m_allContextEqsMap = new HashMap(contextEqs.size());
        for (EquivalenceClass eq : contextEqs) {
            for (String word : eq.getAllWords()) {
                assert (this.m_allContextEqsMap.get(word) == null);
                this.m_allContextEqsMap.put(word, eq);
            }
        }
    }

    @Override
    public void collectProperty(CorpusAccessor corpusAccess, Set<? extends EquivalenceClass> phrases) throws Exception {
        String curLine;
        BufferedReader reader = new BufferedReader(corpusAccess.getCorpusReader());
        HashMap<String, EquivalenceClass> phMap = new HashMap<String, EquivalenceClass>(phrases.size());
        for (EquivalenceClass equivalenceClass : phrases) {
            phMap.put(equivalenceClass.getStem(), equivalenceClass);
        }
        while ((curLine = reader.readLine()) != null) {
            curLine = curLine.trim();
            List<String> curSents = PhraseContextCollector.getSentences(curLine, corpusAccess.isOneSentencePerLine());
            for (String string : curSents) {
                List<PhrasePropertyCollector.IdxPair> sentPhraseIdxs = PhraseContextCollector.getAllPhraseIdxs(string, this.m_maxPhraseLength);
                SentWords sentContext = null;
                block3: for (PhrasePropertyCollector.IdxPair phraseIdx : sentPhraseIdxs) {
                    EquivalenceClass foundEq = (EquivalenceClass)phMap.get(EquivalenceClass.getWordOfAppropriateForm(string.substring(phraseIdx.from, phraseIdx.to), this.m_caseSensitive));
                    if (foundEq == null) continue;
                    Context fountEqContext = (Context)foundEq.getProperty(Context.class.getName());
                    if (fountEqContext == null) {
                        fountEqContext = new Context(foundEq);
                        foundEq.setProperty(fountEqContext);
                    }
                    if (sentContext == null) {
                        sentContext = new SentWords(string);
                    }
                    int contextCount = 0;
                    for (String word : sentContext.getLeftContext(phraseIdx.from)) {
                        if (contextCount++ == this.m_leftSize) break;
                        fountEqContext.addContextWord(this.m_caseSensitive, this.m_allContextEqsMap, word);
                    }
                    contextCount = 0;
                    for (String word : sentContext.getRightContext(phraseIdx.to)) {
                        if (contextCount++ == this.m_rightSize) continue block3;
                        fountEqContext.addContextWord(this.m_caseSensitive, this.m_allContextEqsMap, word);
                    }
                }
            }
        }
        reader.close();
    }

    static /* synthetic */ List access$0(String string) {
        return PhrasePropertyCollector.getAllWordIdxs(string);
    }

    class SentWords {
        protected TreeMap<Integer, String> m_leftMap = new TreeMap();
        protected TreeMap<Integer, String> m_rightMap = new TreeMap();

        public SentWords(String sent) {
            for (PhrasePropertyCollector.IdxPair idxPair : PhraseContextCollector.access$0(sent)) {
                String word = sent.substring(idxPair.from, idxPair.to);
                this.m_leftMap.put(-idxPair.to, word);
                this.m_rightMap.put(idxPair.from, word);
            }
        }

        public Collection<String> getRightContext(int sentIdx) {
            return this.m_rightMap.tailMap(sentIdx).values();
        }

        public Collection<String> getLeftContext(int sentIdx) {
            return this.m_leftMap.tailMap(-sentIdx).values();
        }
    }
}

