/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.DependencyGraph;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.edge.Edge;
import org.maltparser.core.syntaxgraph.edge.GraphEdge;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.SingleMalt;
import org.maltparser.parser.Trainer;
import org.maltparser.parser.algorithm.twoplanar3T.TwoPlanar3TConfig;
import org.maltparser.parser.algorithm.uarcstandard.UArcStanConfig;
import org.maltparser.parser.algorithm.ucovington.UcovingtonConfig;
import org.maltparser.parser.guide.ClassifierGuide;
import org.maltparser.parser.guide.OracleGuide;
import org.maltparser.parser.guide.SingleGuide;
import org.maltparser.parser.history.GuideHistory;
import org.maltparser.parser.history.action.GuideDecision;
import org.maltparser.parser.history.action.GuideUserAction;

public class BatchTrainer
extends Trainer {
    private OracleGuide oracleGuide;
    private int parseCount;

    public BatchTrainer(DependencyParserConfig manager) throws MaltChainedException {
        super(manager);
        ((SingleMalt)manager).addRegistry(Algorithm.class, this);
        this.setManager(manager);
        this.initParserState(1);
        this.setGuide(new SingleGuide(manager, (GuideHistory)((Object)this.parserState.getHistory()), ClassifierGuide.GuideMode.BATCH));
        this.oracleGuide = this.parserState.getFactory().makeOracleGuide(this.parserState.getHistory());
    }

    public DependencyStructure parse(DependencyStructure goldDependencyGraph, DependencyStructure parseDependencyGraph) throws MaltChainedException {
        if (this.parserState.getTransitionSystem().getName().compareTo("noplanar") == 0) {
            ((DependencyGraph)parseDependencyGraph).setSingleHeadedConstraint(false);
            ((DependencyGraph)goldDependencyGraph).setSingleHeadedConstraint(false);
            this.parserState.clear();
            this.parserState.initialize(parseDependencyGraph);
            this.codeNoPlanarDupArcsWithTags(goldDependencyGraph);
            this.currentParserConfiguration = this.parserState.getConfiguration();
            ++this.parseCount;
            if (this.diagnostics) {
                this.writeToDiaFile(this.parseCount + "");
            }
            while (!this.parserState.isTerminalState()) {
                GuideUserAction action = this.parserState.getTransitionSystem().getDeterministicAction(this.parserState.getHistory(), this.currentParserConfiguration);
                if (action == null) {
                    action = this.oracleGuide.predict(goldDependencyGraph, this.currentParserConfiguration);
                    try {
                        this.classifierGuide.addInstance((GuideDecision)((Object)action));
                    }
                    catch (NullPointerException e) {
                        throw new MaltChainedException("The guide cannot be found. ", e);
                    }
                } else if (this.diagnostics) {
                    this.writeToDiaFile(" *");
                }
                if (this.diagnostics) {
                    this.writeToDiaFile(" " + this.parserState.getTransitionSystem().getActionString(action));
                }
                this.parserState.apply(action);
            }
            this.copyEdgesForNoPlanar(this.currentParserConfiguration.getDependencyGraph(), parseDependencyGraph);
            this.oracleGuide.finalizeSentence(parseDependencyGraph);
            if (this.diagnostics) {
                this.writeToDiaFile("\n");
            }
            return parseDependencyGraph;
        }
        String opcion = "label";
        if (this.parserState.getTransitionSystem().getName().compareTo("two-planar 3t arc-eager") == 0) {
            opcion = ((TwoPlanar3TConfig)this.parserState.getConfiguration()).getMode();
        }
        if (this.parserState.getTransitionSystem().getName().compareTo("ucovnonproj") == 0) {
            opcion = ((UcovingtonConfig)this.parserState.getConfiguration()).getMode();
        }
        if (this.parserState.getTransitionSystem().getName().compareTo("uarcstandard") == 0) {
            opcion = ((UArcStanConfig)this.parserState.getConfiguration()).getMode();
        }
        if (opcion.compareTo("root") == 0) {
            this.parserState.clear();
            this.parserState.initialize(parseDependencyGraph);
            if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("two-planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("ucovnonproj") == 0 || this.parserState.getTransitionSystem().getName().compareTo("uarcstandard") == 0) {
                ((DependencyGraph)parseDependencyGraph).setSingleHeadedConstraint(false);
            }
            if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t label strategy arc-eager") == 0) {
                ((DependencyGraph)parseDependencyGraph).setSingleHeadedConstraint(false);
                this.depTreeToLabeledUndirectedGraph(goldDependencyGraph);
            }
            this.currentParserConfiguration = this.parserState.getConfiguration();
            ++this.parseCount;
            if (this.diagnostics) {
                this.writeToDiaFile(this.parseCount + "");
            }
            while (!this.parserState.isTerminalState()) {
                GuideUserAction action = this.parserState.getTransitionSystem().getDeterministicAction(this.parserState.getHistory(), this.currentParserConfiguration);
                if (action == null) {
                    action = this.oracleGuide.predict(goldDependencyGraph, this.currentParserConfiguration);
                    try {
                        this.classifierGuide.addInstance((GuideDecision)((Object)action));
                    }
                    catch (NullPointerException e) {
                        throw new MaltChainedException("The guide cannot be found. ", e);
                    }
                } else if (this.diagnostics) {
                    this.writeToDiaFile(" *");
                }
                if (this.diagnostics) {
                    this.writeToDiaFile(" " + this.parserState.getTransitionSystem().getActionString(action));
                }
                this.parserState.apply(action);
            }
            if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("planar 3t label strategy arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("two-planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("ucovnonproj") == 0 || this.parserState.getTransitionSystem().getName().compareTo("uarcstandard") == 0) {
                this.copyEdgesForPlanar3T(this.currentParserConfiguration.getDependencyGraph(), parseDependencyGraph);
            } else {
                this.copyEdges(this.currentParserConfiguration.getDependencyGraph(), parseDependencyGraph);
            }
            parseDependencyGraph.linkAllTreesToRoot();
            this.oracleGuide.finalizeSentence(parseDependencyGraph);
            if (this.diagnostics) {
                this.writeToDiaFile("\n");
            }
            return parseDependencyGraph;
        }
        this.parserState.clear();
        this.parserState.initialize(parseDependencyGraph);
        if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t arc-eager") == 0) {
            ((DependencyGraph)parseDependencyGraph).setSingleHeadedConstraint(false);
            this.dependencyTreeToRigthGraph(goldDependencyGraph);
        }
        if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t label strategy arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("two-planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("ucovnonproj") == 0 || this.parserState.getTransitionSystem().getName().compareTo("uarcstandard") == 0) {
            ((DependencyGraph)parseDependencyGraph).setSingleHeadedConstraint(false);
            this.depTreeToLabeledUndirectedGraph(goldDependencyGraph);
        }
        this.currentParserConfiguration = this.parserState.getConfiguration();
        ++this.parseCount;
        if (this.diagnostics) {
            this.writeToDiaFile(this.parseCount + "");
        }
        while (!this.parserState.isTerminalState()) {
            GuideUserAction action = this.parserState.getTransitionSystem().getDeterministicAction(this.parserState.getHistory(), this.currentParserConfiguration);
            if (action == null) {
                action = this.oracleGuide.predict(goldDependencyGraph, this.currentParserConfiguration);
                try {
                    this.classifierGuide.addInstance((GuideDecision)((Object)action));
                }
                catch (NullPointerException e) {
                    throw new MaltChainedException("The guide cannot be found. ", e);
                }
            } else if (this.diagnostics) {
                this.writeToDiaFile(" *");
            }
            if (this.diagnostics) {
                this.writeToDiaFile(" " + this.parserState.getTransitionSystem().getActionString(action));
            }
            this.parserState.apply(action);
        }
        if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("planar 3t label strategy arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("two-planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("ucovnonproj") == 0 || this.parserState.getTransitionSystem().getName().compareTo("uarcstandard") == 0) {
            this.copyEdgesForPlanar3T(this.currentParserConfiguration.getDependencyGraph(), parseDependencyGraph);
        } else {
            this.copyEdges(this.currentParserConfiguration.getDependencyGraph(), parseDependencyGraph);
        }
        parseDependencyGraph.linkAllTreesToRoot();
        this.oracleGuide.finalizeSentence(parseDependencyGraph);
        if (this.diagnostics) {
            this.writeToDiaFile("\n");
        }
        return parseDependencyGraph;
    }

    public OracleGuide getOracleGuide() {
        return this.oracleGuide;
    }

    public void train() throws MaltChainedException {
    }

    public void terminate() throws MaltChainedException {
        if (this.diagnostics) {
            this.closeDiaWriter();
        }
    }

    private void dependencyTreeToRigthGraph(DependencyStructure graph) throws MaltChainedException {
        TreeSet<Edge> nuevosArcos = new TreeSet<Edge>();
        SortedSet<Edge> arcos = graph.getEdges();
        for (Edge arco : arcos) {
            if (arco.getTarget().getIndex() >= arco.getSource().getIndex()) continue;
            nuevosArcos.add(arco);
        }
        for (Edge ne : nuevosArcos) {
            ((GraphEdge)ne).changeSense(ne.getTarget(), ne.getSource(), 1);
        }
    }

    private void depTreeToLabeledUndirectedGraph(DependencyStructure graph) throws MaltChainedException {
        SortedSet<Edge> edges = graph.getEdges();
        for (Edge edge : edges) {
            Set<String> names = graph.getSymbolTables().getSymbolTableNames();
            for (String name : names) {
                if (name.compareTo("DEPREL") != 0) continue;
                String label = edge.getLabelSymbol(graph.getSymbolTables().getSymbolTable(name));
                label = edge.getSource().getIndex() < edge.getTarget().getIndex() ? label + "R" : label + "L";
                edge.addLabel(graph.getSymbolTables().getSymbolTable(name), label);
            }
        }
    }

    private void codeNoPlanarGraphDuplicatedArcs(DependencyStructure graph) throws MaltChainedException {
        int n = graph.getHighestDependencyNodeIndex();
        Vector<Integer> changes = new Vector<Integer>();
        Vector<Integer> tags = new Vector<Integer>();
        Vector<Edge> removes = new Vector<Edge>();
        for (int nodo = n; nodo >= 1; --nodo) {
            SortedSet<Edge> edges = graph.getEdges();
            block1: for (Edge edge : edges) {
                int dependent2;
                int head2;
                Edge edge2;
                int k;
                Object[] arcs;
                SortedSet<Edge> edges2;
                int dependent;
                if (edge.getTarget().getIndex() != nodo) continue;
                int head = edge.getSource().getIndex();
                if (head < (dependent = edge.getTarget().getIndex())) {
                    edges2 = graph.getEdges();
                    arcs = edges2.toArray();
                    for (k = arcs.length - 1; k >= 0; --k) {
                        edge2 = (Edge)arcs[k];
                        if ((edge2.getSource().getIndex() <= head || edge2.getSource().getIndex() >= dependent) && (edge2.getTarget().getIndex() <= head || edge2.getTarget().getIndex() >= dependent)) continue;
                        head2 = edge2.getSource().getIndex();
                        dependent2 = edge2.getTarget().getIndex();
                        if ((head2 >= head || head >= dependent2 || dependent2 >= dependent) && (dependent2 >= head || head >= head2 || head2 >= dependent)) continue;
                        removes.add(edge);
                        if (head2 < dependent && head2 > head) {
                            changes.add(head);
                            changes.add(head2);
                            tags.add(edge.getLabelCode(graph.getSymbolTables().getSymbolTable("DEPREL")));
                            tags.add(0);
                            changes.add(head2);
                            changes.add(dependent);
                            tags.add(edge.getLabelCode(graph.getSymbolTables().getSymbolTable("DEPREL")));
                            tags.add(0);
                            continue block1;
                        }
                        changes.add(head);
                        changes.add(dependent2);
                        tags.add(edge.getLabelCode(graph.getSymbolTables().getSymbolTable("DEPREL")));
                        tags.add(0);
                        changes.add(dependent2);
                        changes.add(dependent);
                        tags.add(edge.getLabelCode(graph.getSymbolTables().getSymbolTable("DEPREL")));
                        tags.add(0);
                        continue block1;
                    }
                    continue;
                }
                edges2 = graph.getEdges();
                arcs = edges2.toArray();
                for (k = arcs.length - 1; k >= 0; --k) {
                    edge2 = (Edge)arcs[k];
                    if ((edge2.getSource().getIndex() >= head || edge2.getSource().getIndex() <= dependent) && (edge2.getTarget().getIndex() >= head || edge2.getTarget().getIndex() <= dependent)) continue;
                    head2 = edge2.getSource().getIndex();
                    dependent2 = edge2.getTarget().getIndex();
                    if ((head2 >= dependent || dependent >= dependent2 || dependent2 >= head) && (dependent2 >= dependent || dependent >= head2 || head2 >= head)) continue;
                    removes.add(edge);
                    if (head2 > dependent && head2 < head) {
                        changes.add(head);
                        changes.add(head2);
                        tags.add(edge.getLabelCode(graph.getSymbolTables().getSymbolTable("DEPREL")));
                        tags.add(0);
                        changes.add(head2);
                        changes.add(dependent);
                        tags.add(edge.getLabelCode(graph.getSymbolTables().getSymbolTable("DEPREL")));
                        tags.add(0);
                        continue block1;
                    }
                    changes.add(head);
                    changes.add(dependent2);
                    tags.add(edge.getLabelCode(graph.getSymbolTables().getSymbolTable("DEPREL")));
                    tags.add(0);
                    changes.add(dependent2);
                    changes.add(dependent);
                    tags.add(edge.getLabelCode(graph.getSymbolTables().getSymbolTable("DEPREL")));
                    tags.add(0);
                    continue block1;
                }
            }
            if (changes.size() > 0) {
                ++nodo;
            }
            for (int i = 0; i < changes.size(); i += 2) {
                this.addEdgeDuplicated(graph, (Integer)changes.get(i), (Integer)changes.get(i + 1), (Integer)tags.get(i));
            }
            for (int j = 0; j < removes.size(); ++j) {
                this.removeEdgeDuplicated(graph, (Edge)removes.get(j));
            }
            changes.clear();
            tags.clear();
            removes.clear();
        }
    }

    private void addEdge(DependencyStructure dg, int head, int dep, int tag) throws MaltChainedException {
        SortedSet<Edge> edges = dg.getEdges();
        boolean existe = false;
        for (Edge edge : edges) {
            if (edge.getSource().getIndex() != head || edge.getTarget().getIndex() != dep) continue;
            existe = true;
        }
        if (!existe) {
            Edge e = dg.addDependencyEdge(head, dep);
            e.addLabel(dg.getSymbolTables().getSymbolTable("DEPREL"), tag);
        }
    }

    private void addEdgeDuplicated(DependencyStructure dg, int head, int dep, int tag) throws MaltChainedException {
        Edge e = dg.addDependencyEdge(head, dep);
        e.addLabel(dg.getSymbolTables().getSymbolTable("DEPREL"), tag);
    }

    private void removeEdgeDuplicated(DependencyStructure dg, Edge e) throws MaltChainedException {
        SortedSet<Edge> arcos = dg.getEdges();
        TreeSet<Edge> nuevos = new TreeSet<Edge>();
        for (Edge arco : arcos) {
            if (arco.toString().compareTo(e.toString()) == 0) continue;
            nuevos.add(arco);
        }
        arcos.clear();
        for (Edge arco : nuevos) {
            arcos.add(arco);
        }
        dg.getTokenNode(e.getTarget().getIndex()).getHeads().remove(dg.getDependencyNode(e.getSource().getIndex()));
        if (!e.getSource().isRoot()) {
            dg.getTokenNode(e.getSource().getIndex()).getRightDependents().remove(dg.getDependencyNode(e.getTarget().getIndex()));
            dg.getTokenNode(e.getSource().getIndex()).getLeftDependents().remove(dg.getDependencyNode(e.getTarget().getIndex()));
        }
    }

    private void codeNoPlanarDupArcsWithTags(DependencyStructure graph) throws MaltChainedException {
        int n = graph.getHighestDependencyNodeIndex();
        Vector<Integer> changes = new Vector<Integer>();
        Vector<String> tags = new Vector<String>();
        Vector<Edge> removes = new Vector<Edge>();
        for (int nodo = n; nodo >= 1; --nodo) {
            SortedSet<Edge> edges = graph.getEdges();
            block1: for (Edge edge : edges) {
                int dependent2;
                int head2;
                Edge edge2;
                int k;
                Object[] arcs;
                SortedSet<Edge> edges2;
                int dependent;
                if (edge.getTarget().getIndex() != nodo) continue;
                int head = edge.getSource().getIndex();
                if (head < (dependent = edge.getTarget().getIndex())) {
                    edges2 = graph.getEdges();
                    arcs = edges2.toArray();
                    for (k = arcs.length - 1; k >= 0; --k) {
                        edge2 = (Edge)arcs[k];
                        if ((edge2.getSource().getIndex() <= head || edge2.getSource().getIndex() >= dependent) && (edge2.getTarget().getIndex() <= head || edge2.getTarget().getIndex() >= dependent)) continue;
                        head2 = edge2.getSource().getIndex();
                        dependent2 = edge2.getTarget().getIndex();
                        if ((head2 >= head || head >= dependent2 || dependent2 >= dependent) && (dependent2 >= head || head >= head2 || head2 >= dependent)) continue;
                        removes.add(edge);
                        if (head2 < dependent && head2 > head) {
                            changes.add(head);
                            changes.add(head2);
                            tags.add(edge.getLabelSymbol(graph.getSymbolTables().getSymbolTable("DEPREL")));
                            tags.add("0");
                            changes.add(head2);
                            changes.add(dependent);
                            tags.add(edge.getLabelSymbol(graph.getSymbolTables().getSymbolTable("DEPREL")));
                            tags.add("0");
                            continue block1;
                        }
                        changes.add(head);
                        changes.add(dependent2);
                        tags.add(edge.getLabelSymbol(graph.getSymbolTables().getSymbolTable("DEPREL")));
                        tags.add("0");
                        changes.add(dependent2);
                        changes.add(dependent);
                        tags.add(edge.getLabelSymbol(graph.getSymbolTables().getSymbolTable("DEPREL")));
                        tags.add("0");
                        continue block1;
                    }
                    continue;
                }
                edges2 = graph.getEdges();
                arcs = edges2.toArray();
                for (k = arcs.length - 1; k >= 0; --k) {
                    edge2 = (Edge)arcs[k];
                    if ((edge2.getSource().getIndex() >= head || edge2.getSource().getIndex() <= dependent) && (edge2.getTarget().getIndex() >= head || edge2.getTarget().getIndex() <= dependent)) continue;
                    head2 = edge2.getSource().getIndex();
                    dependent2 = edge2.getTarget().getIndex();
                    if ((head2 >= dependent || dependent >= dependent2 || dependent2 >= head) && (dependent2 >= dependent || dependent >= head2 || head2 >= head)) continue;
                    removes.add(edge);
                    if (head2 > dependent && head2 < head) {
                        changes.add(head);
                        changes.add(head2);
                        tags.add(edge.getLabelSymbol(graph.getSymbolTables().getSymbolTable("DEPREL")));
                        tags.add("0");
                        changes.add(head2);
                        changes.add(dependent);
                        tags.add(edge.getLabelSymbol(graph.getSymbolTables().getSymbolTable("DEPREL")));
                        tags.add("0");
                        continue block1;
                    }
                    changes.add(head);
                    changes.add(dependent2);
                    tags.add(edge.getLabelSymbol(graph.getSymbolTables().getSymbolTable("DEPREL")));
                    tags.add("0");
                    changes.add(dependent2);
                    changes.add(dependent);
                    tags.add(edge.getLabelSymbol(graph.getSymbolTables().getSymbolTable("DEPREL")));
                    tags.add("0");
                    continue block1;
                }
            }
            if (changes.size() > 0) {
                ++nodo;
            }
            for (int i = 0; i < changes.size(); i += 2) {
                this.addEdgeDuplicatedWithTags(graph, (Integer)changes.get(i), (Integer)changes.get(i + 1), (String)tags.get(i));
            }
            for (int j = 0; j < removes.size(); ++j) {
                this.removeEdgeDuplicated(graph, (Edge)removes.get(j));
            }
            changes.clear();
            tags.clear();
            removes.clear();
        }
    }

    private void addEdgeDuplicatedWithTags(DependencyStructure dg, int head, int dep, String tag) throws MaltChainedException {
        if (tag.charAt(tag.length() - 1) == '&') {
            Edge e = dg.addDependencyEdge(head, dep);
            e.addLabel(dg.getSymbolTables().getSymbolTable("DEPREL"), tag);
        } else {
            Edge e = dg.addDependencyEdge(head, dep);
            tag = tag + "&";
            e.addLabel(dg.getSymbolTables().getSymbolTable("DEPREL"), tag);
        }
    }
}

