/*
 * Decompiled with CFR 0.152.
 */
package segmenter;

import segmenter.AbstractAPSegmenterDP;
import segmenter.WindowMatrix;
import similarity.ISimComputer;
import similarity.TripletSim;

public class AffinityPropagationSegmenterSparse
extends AbstractAPSegmenterDP {
    private int winSize = 0;

    @Override
    public void Init(ISimComputer iSimComputer) throws Exception {
        int n;
        int n2;
        this.numPoints = iSimComputer.GetPointsNumber();
        this.winSize = iSimComputer.GetWindowSize();
        this.similarities = new WindowMatrix(this.numPoints, this.winSize);
        for (n2 = 0; n2 < this.similarities.GetNumRows(); ++n2) {
            for (n = 0; n < this.similarities.GetNumColumns(); ++n) {
                this.similarities.SetElement(n2, n, Double.NEGATIVE_INFINITY);
            }
            this.similarities.SetRowStart(n2, -1);
            this.similarities.SetRowEnd(n2, -1);
            this.similarities.SetColumnStart(n2, -1);
            this.similarities.SetColumnEnd(n2, -1);
        }
        this.resp = new WindowMatrix(this.numPoints, this.winSize);
        this.avail = new WindowMatrix(this.numPoints, this.winSize);
        n2 = -1;
        n = -1;
        TripletSim tripletSim = null;
        for (TripletSim tripletSim2 : iSimComputer.GetSimilarities()) {
            int n3;
            int n4;
            if (tripletSim2.firstId < n2) {
                String string = "Exception in AffinityPropagationPSegmenterSparse.Init: row index out of order: " + tripletSim2.ToString();
                throw new Exception(string);
            }
            if (tripletSim2.secondId < n) {
                String string = "Exception in AffinityPropagationPSegmenterSparse.Init: col index out of order: " + tripletSim2.ToString();
                throw new Exception(string);
            }
            if (tripletSim2.firstId > n2) {
                this.similarities.SetRowStart(tripletSim2.firstId, tripletSim2.secondId);
                if (n2 != -1) {
                    this.similarities.SetRowEnd(n2, tripletSim.secondId);
                }
                n2 = tripletSim2.firstId;
                n = tripletSim2.secondId;
            }
            if ((n4 = this.similarities.GetColumnStart(tripletSim2.secondId)) == -1) {
                this.similarities.SetColumnStart(tripletSim2.secondId, tripletSim2.firstId);
            }
            if ((n3 = this.similarities.GetColumnEnd(tripletSim2.secondId)) == -1) {
                this.similarities.SetColumnEnd(tripletSim2.secondId, tripletSim2.firstId);
            } else if (n3 < tripletSim2.firstId) {
                this.similarities.SetColumnEnd(tripletSim2.secondId, tripletSim2.firstId);
            }
            this.similarities.SetElement(tripletSim2.firstId, tripletSim2.secondId, tripletSim2.similarity);
            tripletSim = tripletSim2;
        }
        this.similarities.SetRowEnd(tripletSim.firstId, tripletSim.secondId);
        for (int i = 0; i < this.similarities.GetNumRows(); ++i) {
            this.avail.SetRowStart(i, this.similarities.GetRowStart(i));
            this.avail.SetRowEnd(i, this.similarities.GetRowEnd(i));
            this.avail.SetColumnStart(i, this.similarities.GetColumnStart(i));
            this.avail.SetColumnEnd(i, this.similarities.GetColumnEnd(i));
            this.resp.SetRowStart(i, this.similarities.GetRowStart(i));
            this.resp.SetRowEnd(i, this.similarities.GetRowEnd(i));
            this.resp.SetColumnStart(i, this.similarities.GetColumnStart(i));
            this.resp.SetColumnEnd(i, this.similarities.GetColumnEnd(i));
        }
    }
}

