/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.EstimatorTrie;
import com.aliasi.chunk.Tags;
import com.aliasi.symbol.SymbolTable;
import com.aliasi.tokenizer.TokenCategorizer;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CompiledEstimator {
    private final EstimatorTrie mTagTrie;
    private final EstimatorTrie mTokenTrie;
    private final SymbolTable mTagSymbolTable;
    private final SymbolTable mTokenSymbolTable;
    private final boolean[][] mCannotFollow;
    private final int[] mConvertToInterior;
    private final int[] mStart;
    private final int[] mInterior;
    private final double mLogUniformVocabEstimate;
    private final TokenCategorizer mTokenCategorizer;

    public CompiledEstimator(ObjectInput in) throws ClassNotFoundException, IOException {
        this.mTokenCategorizer = (TokenCategorizer)in.readObject();
        this.mTagSymbolTable = (SymbolTable)in.readObject();
        this.mTokenSymbolTable = (SymbolTable)in.readObject();
        this.mTagTrie = new EstimatorTrie(in);
        this.mTokenTrie = new EstimatorTrie(in);
        this.mLogUniformVocabEstimate = in.readDouble();
        int numSymbols = this.mTagSymbolTable.numSymbols();
        this.mConvertToInterior = new int[numSymbols];
        this.mCannotFollow = new boolean[numSymbols][numSymbols];
        int numTags = this.mTagSymbolTable.numSymbols();
        ArrayList<Integer> starts = new ArrayList<Integer>();
        ArrayList<Integer> interiors = new ArrayList<Integer>();
        for (int tagID = 0; tagID < numTags; ++tagID) {
            String tag = this.idToTag(tagID);
            this.mConvertToInterior[tagID] = this.tagToInteriorID(tag);
            if (tagID != this.mConvertToInterior[tagID]) {
                interiors.add(this.mConvertToInterior[tagID]);
                starts.add(tagID);
            }
            for (int tagMinus1ID = 0; tagMinus1ID < numTags; ++tagMinus1ID) {
                this.mCannotFollow[tagID][tagMinus1ID] = Tags.illegalSequence(this.idToTag(tagMinus1ID), tag);
            }
        }
        this.mStart = CompiledEstimator.convertToIntArray(starts);
        this.mInterior = CompiledEstimator.convertToIntArray(interiors);
    }

    public int[] startTagIDs() {
        return this.mStart;
    }

    public int[] interiorTagIDs() {
        return this.mInterior;
    }

    public int numTags() {
        return this.mTagSymbolTable.numSymbols();
    }

    public int tagToID(String tag) {
        return this.mTagSymbolTable.symbolToID(tag);
    }

    public String idToTag(int id) {
        return this.mTagSymbolTable.idToSymbol(id);
    }

    public int tokenToID(String token) {
        return this.mTokenSymbolTable.symbolToID(token);
    }

    public int tokenOrCategoryToID(String token) {
        int id = this.tokenToID(token);
        if (id < 0 && (id = this.tokenToID(this.mTokenCategorizer.categorize(token))) < 0) {
            System.err.println("No id for token category: " + token);
        }
        return id;
    }

    public String idToToken(int id) {
        return this.mTokenSymbolTable.idToSymbol(id);
    }

    public boolean cannotFollow(int tagID, int tagMinus1ID) {
        return this.mCannotFollow[tagID][tagMinus1ID];
    }

    private int idToInteriorID(int tagID) {
        return this.mConvertToInterior[tagID];
    }

    public double estimate(int tagID, int tokenID, int tagMinus1ID, int tokenMinus1ID, int tokenMinus2ID) {
        if (this.cannotFollow(tagID, tagMinus1ID)) {
            return Double.NaN;
        }
        int tagMinus1IDInterior = this.idToInteriorID(tagMinus1ID);
        return this.estimateTag(tagID, tagMinus1IDInterior, tokenMinus1ID, tokenMinus2ID) + this.estimateToken(tokenID, tagID, tagMinus1IDInterior, tokenMinus1ID);
    }

    private double estimateTag(int tagID, int tagMinus1ID, int tokenMinus1ID, int tokenMinus2ID) {
        int nodeTag1Index = this.mTagTrie.lookupChild(tagMinus1ID, 0);
        if (nodeTag1Index == -1) {
            return Double.NaN;
        }
        int nodeTag1W1Index = this.mTagTrie.lookupChild(tokenMinus1ID, nodeTag1Index);
        if (nodeTag1W1Index == -1) {
            return this.mTagTrie.estimateFromNode(tagID, nodeTag1Index);
        }
        int nodeTag1W1W2Index = this.mTagTrie.lookupChild(tokenMinus2ID, nodeTag1W1Index);
        if (nodeTag1W1W2Index == -1) {
            return this.mTagTrie.estimateFromNode(tagID, nodeTag1W1Index);
        }
        return this.mTagTrie.estimateFromNode(tagID, nodeTag1W1W2Index);
    }

    private double estimateToken(int tokenID, int tagID, int tagMinus1ID, int tokenMinus1ID) {
        int nodeTagIndex = this.mTokenTrie.lookupChild(tagID, 0);
        if (nodeTagIndex == -1) {
            return Double.NaN;
        }
        int nodeTagTag1Index = this.mTokenTrie.lookupChild(tagMinus1ID, nodeTagIndex);
        if (nodeTagTag1Index == -1) {
            return this.mTokenTrie.estimateFromNodeUniform(tokenID, nodeTagIndex, this.mLogUniformVocabEstimate);
        }
        int nodeTagTag1W1Index = this.mTokenTrie.lookupChild(tokenMinus1ID, nodeTagTag1Index);
        if (nodeTagTag1W1Index != -1) {
            return this.mTokenTrie.estimateFromNodeUniform(tokenID, nodeTagTag1W1Index, this.mLogUniformVocabEstimate);
        }
        return this.mTokenTrie.estimateFromNodeUniform(tokenID, nodeTagTag1Index, this.mLogUniformVocabEstimate);
    }

    private int tagToInteriorID(String tag) {
        return this.tagToID(Tags.toInnerTag(tag));
    }

    private static int[] convertToIntArray(List<Integer> xs) {
        int[] result = new int[xs.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = xs.get(i);
        }
        return result;
    }
}

