import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns

if __name__ == '__main__':
    metrics = ['BLEU-2', 'ChrF', 'RUBY', 'CBS', 'Pass']
    scores = pd.read_csv('results/scores.csv')
    scores = [scores[metric].to_numpy() for metric in metrics]
    coef = np.corrcoef(scores)
    plt.rcParams['font.family'] = 'Times New Roman'
    plt.rcParams['font.size'] = 32
    fig, ax = plt.subplots(figsize=(10, 10))
    ax = sns.heatmap(coef[::-1], ax=ax, annot=True, cbar=False)
    ax.xaxis.set_ticklabels(metrics)
    ax.yaxis.set_ticklabels(metrics[::-1])
    ax.set_title('Correlation Coefficient')
    plt.tight_layout(pad=0.1)
    plt.savefig('corrcoef.pdf')
    plt.close()
