theory question_94_0
imports Main

begin

typedecl entity
typedecl event

consts
  He :: "entity ⇒ bool"
  Andy :: "entity ⇒ bool"
  LivesIn :: "entity ⇒ entity ⇒ bool"
  Experiences :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Winter :: "event ⇒ bool"
  August :: "event ⇒ bool"

theorem hypothesis:
  (* Premise: andy lives in the southern hemisphere. *)
  assumes asm: "Andy x ∧ LivesIn x SouthernHemisphere"
  (* Hypothesis: He experiences winter in August. *)
  shows "∃x e. He x  ∧ Experiences e  ∧ Agent e  x  ∧ Winter e  ∧ August e "
proof -
  from asm have "LivesIn x SouthernHemisphere" by simp
  then have "SouthernHemisphere x" by simp
  then have "Winter e ∧ August e" using explanation_1 by blast
  then have "Experiences e" using explanation_1 by blast
  then have "Agent e x" using explanation_1 by blast
  then show "He x ∧ Experiences e ∧ Agent e x ∧ Winter e ∧ August e" by simp
qed
end
