theory question_67_5
imports Main

begin

typedecl entity
typedecl event

consts
  ChangeInEnergy :: "entity ⇒ bool"
  Occurs :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  TurnedOn :: "entity ⇒ bool"
  Convert :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Result :: "event ⇒ entity ⇒ bool"
  DifferentForms :: "entity ⇒ bool"
  ElectricalEnergy :: "entity ⇒ bool"
  LightEnergy :: "entity ⇒ bool"

(* Explanation: Energy can change from one form to another. *)
axiomatization where
  explanation: "∀x y e. ChangeInEnergy x ⟶ (∃e'. Convert e ⟶ Occurs e' ∧ Agent e' x ∧ Patient e' y ∧ DifferentForms y)"

theorem hypothesis:
  (* Premise: when a light bulb is turned on, energy changes from one form to another. *)
  assumes asm: "LightBulb x ∧ TurnedOn x ∧ Occurs e ∧ Agent e x ∧ ChangeInEnergy x ∧ Patient e y ∧ DifferentForms y"
  (* Hypothesis: The change best described is from electrical energy to light energy. *)
  shows "∃x y e. ChangeInEnergy x ∧ Agent e x ∧ Patient e y ∧ ElectricalEnergy x ∧ LightEnergy y"
proof -
  from asm have "ChangeInEnergy x" by simp
  then obtain e' where e': "Convert e ⟶ Occurs e' ∧ Agent e' x ∧ Patient e' y ∧ DifferentForms y" using explanation by blast
  then have "ElectricalEnergy x" using asm by simp
  then have "LightEnergy y" using e' by simp
  then show "∃x y e. ChangeInEnergy x ∧ Agent e x ∧ Patient e y ∧ ElectricalEnergy x ∧ LightEnergy y" using asm e' by blast
qed

end
