theory question_74_2
imports Main

begin

typedecl entity
typedecl event

consts
  Creating :: "event ⇒ bool"
  WoodFreePaper :: "entity ⇒ bool"
  NonWoodFibers :: "entity ⇒ bool"
  CuttingDown :: "event ⇒ entity ⇒ bool"
  Saves :: "entity ⇒ bool" (* changed type from "event ⇒ entity ⇒ bool" to "entity ⇒ bool" *)
  Pulped :: "entity ⇒ bool"
  PaperProduction :: "entity ⇒ bool"
  AroundTheWorld :: "entity ⇒ bool"

(* Explanation 1: Creating wood-free paper by pulping non-wood fibers does not require cutting down trees, which saves trees. *)
axiomatization where
  explanation_1: "∀x y z. Creating x ∧ WoodFreePaper y ∧ NonWoodFibers z ⟶ ¬CuttingDown x Trees ∧ Saves Trees" (* changed from "Saves x Trees" to "Saves Trees" *)

(* Explanation 2: Dozens of non-wood fibers are pulped for paper production around the world, which saves trees as it does not involve cutting down trees. *)
axiomatization where
  explanation_2: "∃x. NonWoodFibers x ∧ Pulped x ∧ PaperProduction x ∧ AroundTheWorld x ⟶ Saves Trees ∧ ¬Involves x (CuttingDown Trees)"

theorem hypothesis:
  assumes asm: "PulpingFibres x ∧ Paper y"
  (* Hypothesis: Pulping fibres for paper saves trees. *)
  shows "Saves Trees"
proof -
  from asm have "PulpingFibres x" by simp
  then obtain e where e: "Pulped e ∧ PaperProduction e ∧ AroundTheWorld e" using explanation_2 by blast
  then have "NonWoodFibers e" using explanation_2 by blast
  have conclusion: "Creating (Paper e) ∧ WoodFreePaper (Paper e) ∧ NonWoodFibers e" using e by simp
  show ?thesis using asm conclusion explanation_1 by blast
qed

end
