theory question_74_1
imports Main

begin

typedecl entity
typedecl event

consts
  Creating :: "event ⇒ bool"
  WoodFreePaper :: "entity ⇒ bool"
  NonWoodFibers :: "entity ⇒ bool"
  Requires :: "event ⇒ bool"
  CuttingDown :: "event ⇒ bool"
  Trees :: "event ⇒ bool"
  Dozens :: "entity ⇒ bool"
  PaperProduction :: "entity ⇒ bool"
  Pulping :: "entity ⇒ entity ⇒ bool"
  World :: "entity ⇒ bool"

(* Explanation 1: Creating wood-free paper by pulping non-wood fibers does not require cutting down trees. *)
axiomatization where
  explanation_1: "∀x y z. Creating x ∧ WoodFreePaper y ∧ NonWoodFibers z ⟶ ¬Requires x ∧ CuttingDown x ∧ Trees x"

(* Explanation 2: Dozens of non-wood fibers are pulped for paper production around the world. *)
axiomatization where
  explanation_2: "∃x y. Dozens x ∧ NonWoodFibers y ∧ Pulping x y ∧ PaperProduction y ∧ World x"

theorem hypothesis:
  assumes asm: "Pulping fibers e ∧ Fibres fibers ∧ Paper paper "
  (* Hypothesis: Pulping fibers for paper saves trees. *)
  shows "Saves pulping ∧ Trees pulping "
proof -
  from asm have "Pulping fibers e ∧ Fibres fibers ∧ Paper paper " by simp
  then have "NonWoodFibers fibers" by simp
  then have "∃x. Does x ∧ NonWoodFibers fibers ∧ Pulping x fibers ∧ PaperProduction paper ∧ World x" using explanation_2 by blast
  then have "Saves pulping" by (rule explanation_1)
  then have "Trees pulping" by (rule explanation_1)
  then show "Saves pulping ∧ Trees pulping" by simp
qed

end
