theory question_21_7

imports Main

begin

typedecl entity

consts
  EndothermicTetrapodVertebrate :: "entity ⇒ bool"
  BelongToClassAves :: "entity ⇒ bool"
  Aves :: "entity ⇒ bool"

(* Explanation 1: Endothermic tetrapod vertebrates that belong to Class Aves are birds. *)
axiomatization where
  explanation_1: "∀x. EndothermicTetrapodVertebrate x ∧ BelongToClassAves x ⟶ Bird x"

(* Explanation 2: Birds are endothermic tetrapod vertebrates that belong to the official taxonomic classification for birds, which is Class Aves. *)
axiomatization where
  explanation_2: "∀x. Bird x ⟶ (EndothermicTetrapodVertebrate x ∧ BelongToClassAves x)"

(* Explanation 3: Any entity that is an endothermic tetrapod vertebrate and belongs to Class Aves is also classified as an animal in the class Aves (i.e., Aves x). *)
axiomatization where
  explanation_3: "∀x. (EndothermicTetrapodVertebrate x ∧ BelongToClassAves x) ⟶ Aves x"

theorem hypothesis:
  assumes asm: "EndothermicTetrapodVertebrate x"
  (* Hypothesis: An endothermic tetrapod vertebrate would be animals in the class aves. *)
  shows "Aves x"
proof -
  from asm have "EndothermicTetrapodVertebrate x ∧ BelongToClassAves x" by simp
  then show "Aves x" using explanation_3 by blast
qed

end
