theory question_65_9
imports Main

begin

typedecl entity
typedecl event

consts
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Switch :: "entity ⇒ bool"
  PowerSource :: "entity ⇒ bool"
  Closing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Allows :: "event ⇒ entity ⇒ bool"
  Flowing :: "event ⇒ entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  Connected :: "entity ⇒ bool"
  Causes :: "event ⇒ event ⇒ bool"
  TurnOn :: "event ⇒ entity ⇒ bool"
  Emit :: "event ⇒ entity ⇒ bool"
  Electricity :: "entity ⇒ bool"
  ComesOn :: "event ⇒ bool"

(* Explanation 1: In a simple series circuit, closing the switch allows electricity to flow from the power source. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. SimpleSeriesCircuit x ∧ Switch y ∧ PowerSource z ∧ Closing e1 ∧ Agent e1 y ∧ Allows e2 x ∧ Flowing e2 x ∧ Agent e2 x ∧ Patient e2 z"

(* Explanation 2: When electricity flows from a power source to a connected light bulb, it causes the light bulb to turn on and emit light. *)
axiomatization where
  explanation_2: "∀x y z e1 e2 e3 e4. PowerSource x ∧ LightBulb y ∧ Connected z ∧ Flowing e1 x ∧ Agent e1 x ∧ Patient e1 y ∧ Causes e2 e1 ∧ TurnOn e3 y ∧ Agent e3 y ∧ Emit e4 y"

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: "SimpleSeriesCircuit x ∧ Switch y ∧ Closing e ∧ Agent e y"
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃x y e1 e2. Electricity x ∧ LightBulb y ∧ Flowing e3 ∧ Agent e3 x ∧ Patient e3 y ∧ ComesOn e2 ∧ Agent e2 y"
proof -
  {
    assume asm: "SimpleSeriesCircuit x ∧ Switch y ∧ Closing e ∧ Agent e y"
    from asm have "SimpleSeriesCircuit x" by simp
    from explanation_1[OF this]
    obtain z e1 e2 where e1: "PowerSource z" and e2: "Closing e1 ∧ Agent e1 y ∧ Allows e2 x ∧ Flowing e2 x ∧ Agent e2 x ∧ Patient e2 z"
      by blast
    from e2 have "Flowing e2 x" by simp
    from explanation_2[OF e1, OF this]
    obtain y' e3 e4 where e3: "LightBulb y' ∧ Connected y' ∧ Causes e3 e2 ∧ TurnOn e4 y' ∧ Agent e4 y'"
      by blast
    from e3 have "Causes e3 e2" by simp
    from ‹Flowing e2 x› have "Agent e2 x" by simp
    from ‹Causes e3 e2› ‹Agent e2 x› have "Agent e3 x" by simp
    from ‹Causes e3 e2› ‹Patient e2 z› have "Patient e3 y'" by simp
    from ‹TurnOn e4 y'› have "Electricity y'" by simp
    from ‹TurnOn e4 y'› have "Agent e4 y'" by simp
    from ‹TurnOn e4 y'› have "ComesOn e4" by simp
    from ‹LightBulb y'› ‹Electricity y'› ‹Flowing e3 x› ‹Agent e3 x› ‹Patient e3 y'› ‹ComesOn e4› ‹Agent e4 y'›
    show ?thesis by blast
  }
qed

end
