theory question_80_0

imports Main

begin

typedecl entity
typedecl event

consts
  Insulator :: "entity ⇒ bool"
  Conductor :: "entity ⇒ bool"
  Rubber :: "entity ⇒ bool"
  Wood :: "entity ⇒ bool"
  Plastic :: "entity ⇒ bool"
  Metal :: "entity ⇒ bool"
  Material :: "entity ⇒ bool"
  Copper :: "entity ⇒ bool"
  Electricity :: "entity ⇒ bool"
  ElectricalEnergy :: "entity ⇒ bool"
  ThermalEnergy :: "entity ⇒ bool"

(* Explanation 1: an insulator is the opposite of a conductor. *)
axiomatization where
  explanation_1: "∀x. Insulator(x) ↔ ¬Conductor(x)"

(* Explanation 2: rubber is an electrical; electrical energy; thermal; thermal energy insulator. *)
axiomatization where
  explanation_2: "∀x. Rubber(x) ∧ Insulator(x) ∧ ElectricalEnergy(x) ∧ ThermalEnergy(x)"

(* Explanation 3: wood is an electrical; electrical energy; thermal energy insulator. *)
axiomatization where
  explanation_3: "∀x. Wood(x) ∧ Insulator(x) ∧ ElectricalEnergy(x) ∧ ThermalEnergy(x)"

(* Explanation 4: plastic is usually an electrical insulator. *)
axiomatization where
  explanation_4: "∀x. Plastic(x) ∧ Usually(x) ∧ Insulator(x) ∧ ElectricalEnergy(x)"

(* Explanation 5: metal is an electrical; electrical energy conductor. *)
axiomatization where
  explanation_5: "∀x. Metal(x) ∧ ConductsElectricity(x) ∧ ElectricalEnergy(x)"

(* Explanation 6: metal is a kind of material. *)
axiomatization where
  explanation_6: "∀x. Metal(x) ∧ Material(x)"

(* Explanation 7: copper is a kind of metal. *)
axiomatization where
  explanation_7: "∀x. Copper(x) ∧ Metal(x)"

(* Explanation 8: electricity means electrical energy. *)
axiomatization where
  explanation_8: "∀x. Electricity(x) ↔ ElectricalEnergy(x)"

end

theorem hypothesis:
  assumes asm: ""
  shows ""
proof -
  from asm have "Material x" by simp
  then obtain e1 where e1: "ConductsElectricity x ∧ Material x" using explanation_5 by blast
  then have "Copper x" using explanation_7 by blast
  have conclusion: "ConductsElectricity x ∧ Material x" using e1 by simp
  show ?thesis using asm conclusion `Copper x` by blast
qed

end
