theory question_45_0

imports Main

begin

typedecl entity
typedecl event
consts
  Woman :: "entity ⇒ bool"
  Street :: "entity ⇒ bool"
  Running :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Outdoors :: "event ⇒ bool"
  BlackClothing :: "entity ⇒ bool"
  Barefoot :: "event ⇒ bool"
  NextTo :: "event ⇒ entity ⇒ bool"
  PeopleOnBicycles :: "entity ⇒ bool"
  FemaleRunner :: "entity ⇒ bool"

(* Explanation 1: A woman running down the street is outdoors. *)
axiomatization where
  explanation_1: "∀x y e. Woman x ∧ Street y ∧ Running e ∧ Agent e x ∧ Outdoors e"

theorem hypothesis:
  (* Premise: A woman in black clothing runs down the street barefoot next to two people on bicycles and a female runner. *)
  assumes asm: "Woman x  ∧ BlackClothing x  ∧ Street y  ∧ Running e1  ∧ Barefoot e2  ∧ Agent e1  x  ∧ Agent e2  x  ∧ NextTo e1  z  ∧ PeopleOnBicycles z  ∧ FemaleRunner z "
  (* Hypothesis: The woman is outdoors. *)
  shows "∃x e. Woman x  ∧ Outdoors e  ∧ Running e  ∧ Agent e  x "
proof -
  from asm have "Woman x" by blast
  from this have "Outdoors e" using explanation_1 by blast
  show ?thesis using `Woman x` `Outdoors e` by blast
qed

end
