theory question_81_0

imports Main

begin

typedecl entity
typedecl event

consts
  BottleneckEffect :: "entity ⇒ bool"
  Population :: "entity ⇒ bool"
  Suddenly :: "entity ⇒ bool"
  Smaller :: "entity ⇒ bool"
  Occurs :: "event ⇒ bool"
  Gets :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  PopulationGrowth :: "entity ⇒ bool"
  ExternalMigration :: "entity ⇒ bool"
  Reduced :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Bottleneck effect occurs when a population suddenly gets much smaller. *)
axiomatization where
  explanation_1: "∀x y e1 e2. BottleneckEffect x ∧ Population y ∧ Suddenly y ∧ Smaller y ∧ Occurs e1 ∧ Agent e1 x ∧ Gets e2 ∧ Agent e2 y"

(* Explanation 2: Population growth is reduced by external migration. *)
axiomatization where
  explanation_2: "∀x y e. PopulationGrowth x ∧ ExternalMigration y ∧ Reduced e ∧ Agent e x ∧ Patient e y"  

theorem hypothesis:
  assumes asm: "BottleneckEffect x ∧ ExternalMigration y"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃x y e. BottleneckEffect x ∧ ExternalMigration y ∧ Occurs e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "BottleneckEffect x" by simp
  then obtain e1 where e1: "Occurs e1 ∧ Agent e1 x" using explanation_1 by blast
  from asm have "ExternalMigration y" by simp
  then obtain e2 where e2: "Reduced e2 ∧ Agent e2 x ∧ Patient e2 y" using explanation_2 by blast
  have conclusion: "Occurs e1 ∧ Agent e1 x ∧ Patient e2 y" using e1 e2 by simp
  show ?thesis using asm conclusion by blast
qed

end
