theory question_86_0
imports Main

begin
typedecl entity
typedecl event

consts
  Women :: "entity ⇒ bool"
  Talking :: "event ⇒ bool"
  Conversing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Table :: "entity ⇒ bool"
  Drinks :: "entity ⇒ bool"
  Three :: "entity ⇒ bool"
  At :: "entity ⇒ entity ⇒ bool"
  With :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: The women are talking because they are conversing. *)
axiomatization where
  explanation_1: "∀x e. Women x ∧ Talking e ∧ Agent e x ⟶ (∃e. Conversing e ∧ Agent e x)"

theorem hypothesis:
  (* Premise: There are three woman conversing at a table with drinks. *)
  assumes asm: "Women x ∧ Table y ∧ Drinks z ∧ Three x ∧ At x y ∧ With x z ∧ Conversing e ∧ Agent e x"
  (* Hypothesis: Women are talking *)
  shows "∃x e. Women x ∧ Talking e ∧ Agent e x"
proof -
  from asm have "Women x ∧ Conversing e ∧ Agent e x" by blast
  then have "Women x ∧ Talking e ∧ Agent e x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
