theory question_57_1

imports Main

begin
typedecl entity
typedecl event

consts
  MaintenanceWorker :: "entity ⇒ bool"
  Worker :: "entity ⇒ bool"
  Statue :: "entity ⇒ bool"
  Walking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A maintenance worker is a worker. *)
axiomatization where
  explanation_1: "∀x. MaintenanceWorker x ⟶ Worker x"

theorem hypothesis:
  (* Premise: A maintenance worker walking past a statue. *)
  assumes asm: "MaintenanceWorker x ∧ Statue y ∧ Walking e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: Worker walking by a statue *)
  shows "∃x y e. Worker x ∧ Statue y ∧ Walking e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "MaintenanceWorker x ∧ Statue y ∧ Walking e ∧ Agent e x ∧ Patient e y" by blast
  then have "Worker x ∧ Statue y ∧ Walking e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
