theory question_81_3
imports Main
begin

typedecl entity
typedecl event

consts
  Soil :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Environment :: "entity ⇒ bool"
  Forest :: "entity ⇒ bool"
  Nonliving :: "entity ⇒ bool"

(* Explanation 1: Soil is usually part of an environment. *)
axiomatization where
  explanation_1: "∀x y. Soil x ⟶ (∃e. PartOf e x y ∧ Agent e x ∧ Patient e y ∧ Environment y)"

theorem hypothesis:
  assumes asm: "Soil x ∧ Forest y"
  (* Hypothesis: Soil is a nonliving part of a forest. *)
  shows "∃x y. Soil x ∧ Forest y ∧ PartOf x y ∧ Nonliving x"
proof -
  from asm have "Soil x" and "Forest y" by auto
  then obtain e where e: "PartOf e x y ∧ Agent e x ∧ Patient e y ∧ Environment y" using explanation_1 by blast
  then have "Nonliving x" using e by blast
  show ?thesis using `Soil x` `Forest y` e `Nonliving x` by blast
qed

end
