theory question_85_2

imports Main

begin

typedecl entity
typedecl event

consts
  PacinianCorpuscles :: "entity ⇒ bool"
  PressureReceptors :: "entity ⇒ bool"
  Skin :: "entity ⇒ bool"
  Found :: "event ⇒ bool"
  Location :: "event ⇒ entity ⇒ entity ⇒ bool"

(* Explanation 1: Pacinian corpuscles, being a type of pressure receptors, are found mainly in the skin. *)
axiomatization where
  explanation_1: "∀x y. PacinianCorpuscles x ∧ PressureReceptors x ∧ Skin y ⟶ Found e ∧ Location e x y"

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x ∧ Skin y"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "∃e. Found e ∧ Location e x y"
proof -
  from asm have "PacinianCorpuscles x ∧ Skin y" by simp
  then have "PressureReceptors x" using explanation_1 by blast
  then obtain e where e: "Found e ∧ Location e x y" using explanation_1 by blast
  show ?thesis using e by blast
qed

end
