theory question_41_1

imports Main

begin
typedecl entity
typedecl event

consts
  Sunny :: "event ⇒ bool"
  Street :: "event ⇒ bool"
  Shining :: "event ⇒ bool"
  Sun :: "event ⇒ bool"
  SunnyStreet :: "event ⇒ bool"
  RedBuilding :: "event ⇒ bool"
  ParkedCars :: "event ⇒ bool"
  ManWalking :: "event ⇒ bool"

(* Explanation 1: If the street is sunny, then the sun is shining. *)
axiomatization where
  explanation_1: "(∃e1. Sunny e1 ∧ Street e1) ⟶ (∃e2. Shining e2 ∧ Sun e2)"
  

theorem hypothesis:
  (* Premise: A sunny street with a red building, parked cars, and a man walking down the road. *)
  assumes asm: "SunnyStreet e ∧ RedBuilding e ∧ ParkedCars e ∧ ManWalking e"
  (* Hypothesis: The sun is shining. *)
  shows "∃e. Shining e ∧ Sun e"
proof -
  from asm have "∃e1. Sunny e1 ∧ Street e1" by blast
  then have "∃e2. Shining e2 ∧ Sun e2" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
