theory question_30_0

imports Main

begin
typedecl entity
typedecl event

consts
  Tricks :: "entity ⇒ bool"
  Skateboard :: "entity ⇒ bool"
  DoingTricks :: "event ⇒ bool"
  InferredAs :: "event ⇒ entity ⇒ bool"
  Human :: "entity ⇒ bool"
  Man :: "entity ⇒ bool"

(* Explanation 1: tricks on a skateboard is inferred as doing tricks *)
axiomatization where
  explanation_1: "∀x y e. Tricks x ∧ Skateboard y ∧ DoingTricks e ∧ InferredAs e x"

theorem hypothesis:
  (* Premise: A man is doing tricks on a skateboard. *)
  assumes asm: "Man x ∧ Skateboard y ∧ DoingTricks e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: A human doing tricks. *)
  shows "∃x e. Human x ∧ DoingTricks e ∧ Agent e x"
proof -
  from asm have "Man x ∧ Skateboard y ∧ DoingTricks e" by blast
  then have "Tricks x ∧ Skateboard y ∧ DoingTricks e" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
