import pickle
import numpy as np
import xlrd
import xlwt

import pandas as pd

#打开excel
from sklearn import preprocessing

import xlsxwriter as xw

LCSpsimi_np = np.load('../data/results/jia_RLCS_simi_np.npy', allow_pickle=True)
Netsimi_np = np.load('../data/results/jia_graph_simi_np.npy', allow_pickle=True)
Figsimi_np = np.load('../data/results/jia_pic_simi_np.npy', allow_pickle=True)
LCS_Netsimi_np = 0.5 * LCSpsimi_np+0.5 * Netsimi_np
LCS_Figsimi_np = 0.5 * LCSpsimi_np+0.5 * Figsimi_np
LCS_Fig_Netsimi_np = 0.4 * LCSpsimi_np+0.3 * Figsimi_np+0.4 * Netsimi_np



index2ccharacter={}
index2cid={}
cid2index={}
idpairs = []
scores = []


def readJia2():

    wb = xlrd.open_workbook('../data/20210520_oracle-radical.xlsx')
    # 按工作簿定位工作表
    sh = wb.sheet_by_name('甲骨文-部件对应表')
    ccount=0
    for i in range(sh.nrows):
        if i == 0:
            continue
        # print(sh.row_values(i))
        li = sh.row_values(i)
        id = li[0]
        id=id.split("_")[3]
        cha=li[1]

        if id not in cid2index.keys():
            index2cid[ccount] = id
            index2ccharacter[ccount] = cha
            cid2index[id]=ccount
            ccount=ccount+1


def getresult(cid1,cid2,method):

    if method=="LCS":
        sim = LCSpsimi_np[cid2index[cid1]][cid2index[cid2]]
    elif method=="Fig":
        sim = Figsimi_np[cid2index[cid1]][cid2index[cid2]]
    elif method=="Net":
        sim = Netsimi_np[cid2index[cid1]][cid2index[cid2]]
    elif method=="LCS_Fig":
        sim = LCS_Figsimi_np[cid2index[cid1]][cid2index[cid2]]
    elif method=="LCS_Net":
        sim = LCS_Netsimi_np[cid2index[cid1]][cid2index[cid2]]
    else:
        sim = LCS_Fig_Netsimi_np[cid2index[cid1]][cid2index[cid2]]
    return round(sim, 4)

def readexcel(path,num):
    wb = xlrd.open_workbook(path)
    # 按工作簿定位工作表
    sh = wb.sheet_by_name('Sheet1')
    for i in range(sh.nrows):
        if i == num:
            break
        li = sh.row_values(i)
        ids = li[0]
        score = li[2]
        idpairs.append(ids)
        scores.append(int(score) * 0.1)



def readannotation(num=50):
    readexcel('../data/sample.xlsx', num)


readJia2()
readannotation(num=6400)

print(len(scores))
sim_scores=[]
for ids in idpairs:
    id1=ids.split("_")[0]
    id2 = ids.split("_")[1]
    sim = getresult(id1, id2, method="Fig")#几种方法LCS,Fig,Net, LCS_Fig,LCS_Net,LCS_Fig_Net
    sim_scores.append(sim)
print(sim_scores)
print(len(sim_scores))


data = pd.DataFrame({'A':np.array(sim_scores),
                     'B':np.array(scores)})
corr=data.corr('spearman')#'spearman'

#data.corr()    #计算pearson相关系数
#data.corr('kendall')      # Kendall Tau相关系数

print(corr)





