import os
import pickle

from test_sister_terms_oov_main import test_all_models_on_micro_lists_main
from word_embeddings_benchmarks_test.test_benchmark import perform_tasks
from test_definition_words_similarity_main import test_definition_with_bert, test_definition


print("----------------TEST BENCHMARKS---------------------")
spearman = perform_tasks()
out = 'data/benchmark_results/spearman'
if not os.path.exists(out):
    os.mkdir(out)
f = open(os.path.join(out, 'standard_model_mapping.pkl'), "wb")
pickle.dump(spearman, f)
f.close()

print("----------------TEST LEMMA VS DEFINITION-----------------")
test_definition_with_bert()
test_definition()


print("----------------TEST OOV SISTER TERMS-------------------")
print("BERT and W2V SISTER TERMS COMPARABLE")
test_all_models_on_micro_lists_main(bert_comparable=True)
print("W2V SISTER TERMS")
test_all_models_on_micro_lists_main()
