import "core-js/stable";

import React from 'react';
import { BrowserRouter as Router, Route, Link } from "react-router-dom";

import Tutorial from './Tutorial.jsx';
import Annotate from './Annotate.jsx';
import Assign from './Assign.jsx';
import Demo from './Demo.jsx';
import MTurk from './MTurk.jsx';
import Feedback from './Feedback.jsx';
import View from './View.jsx';
import NoTask from './NoTask.jsx';
import WorkerPreview from './WorkerPreview.jsx';

// More on routing here:
// https://reacttraining.com/react-router/web/example/basic
// https://blog.pshrmn.com/entry/simple-react-router-v4-tutorial/


const AppRouter = () => (
  <Router>
    <div>
      <Route exact path="/" component={Demo} />
      <Route path="/tutorial/:id" component={Tutorial} />
      <Route path="/assign/:group" component={Assign} />
      <Route path="/annotate/:ui" component={Annotate} />
      <Route path="/preview/:ui" component={WorkerPreview} />
      <Route path="/mturk/externalSubmit" component={MTurk} />
      <Route path="/feedback" component={Feedback} />
      <Route path="/view/:ui" component={View} />
      <Route path="/no-task" component={NoTask} />
    </div>
  </Router>
);

export default AppRouter;
