import argparse
import init

parser = argparse.ArgumentParser(description="Approve all submitted HITs")
parser.add_argument('-s', '--sandbox', help='Do on the sandbox', action='store_true')
parser.add_argument('--hits', help='HITs to approve', nargs="+", default=[])
args = parser.parse_args()

client = init.get_client(args.sandbox)

hits = client.list_hits(MaxResults=100)
for hit in hits['HITs']:
    if len(args.hits) > 0 and hit['HITId'] not in args.hits:
        continue
    print("Assignments for", hit['HITId'])
    print(hit)
    response = client.list_assignments_for_hit(
        HITId=hit['HITId'],
        MaxResults=100,
    )
    for assignment in response['Assignments']:
        print(assignment)
        if assignment['AssignmentStatus'] == 'Submitted':
            app_response = client.approve_assignment(AssignmentId=assignment['AssignmentId'])
            print(app_response)
    print()
