import json
import sys
import copy

orig_file = sys.argv[1]
converted_file = sys.argv[2]

new_file = sys.argv[3]

with open(orig_file) as f_o:
   orig = json.load(f_o)
with open(converted_file) as f_c:
   converted = json.load(f_c)

new_data = {"version": "1.1", "data": []}
for paraphs in orig["data"]:
    new_paraphs = {"title": paraphs["title"], "paragraphs": []}
    for context_info in paraphs["paragraphs"]:
        new_qas = []
        for qa in context_info["qas"]:
           # if "converted_question" in converted[qa["id"]]:
           if converted[qa["id"]]["question"].endswith("?"):
           # if qa["question"].endswith("?"):
               # qa["question"] = converted[qa["id"]]["converted_question"]
               qa["question"] =  converted[qa["id"]]["question"]
               new_qas.append(qa)
        new_context = {"context": context_info["context"], "qas": new_qas}
        if new_context["qas"]:
             new_paraphs["paragraphs"].append(new_context)
    if new_paraphs["paragraphs"]:
        new_data["data"].append(new_paraphs)

with open(new_file, "w") as f_n:
    json.dump(new_data, f_n, indent=4)
