import re

from delphin.mrs import eds, simplemrs
from coli.hrgguru.extract_LFRG import extract_lfrg
from coli.hrgguru.hyper_graph import HyperGraph


def eds_reader(fields, params, direct=False, wipe_names=False):
    if direct:
        eds_literal = fields
    else:
        eds_literal = fields[-2]
    eds_literal = re.sub("\{.*\}", "", eds_literal)
    e = eds.loads_one(eds_literal)
    hg = HyperGraph.from_eds(e, strip_options=params.strip_options)

    if wipe_names:
        hg = hg.to_standardized_node_names()

    return hg


def mrs_reader(fields, params, direct=False, errors="ignore", wipe_names=False):
    if direct:
        mrs_literal = fields
    else:
        mrs_literal = fields[-3]
    mrs_obj = simplemrs.loads_one(mrs_literal, errors=errors)
    hg = HyperGraph.from_mrs(mrs_obj, strip_options=params.strip_options)

    if wipe_names:
        hg = hg.to_standardized_node_names()

    return hg


def lfrg_reader(fields, params, direct=False, wipe_names=False):
    if direct:
        mrs_literal = fields
    else:
        mrs_literal = fields[-3]
    mrs_obj = simplemrs.loads_one(mrs_literal)
    hg = extract_lfrg(mrs_obj, params.extra["include_qeq"], False)

    if wipe_names:
        hg = hg.to_standardized_node_names()

    return hg


graph_readers = {"eds": eds_reader, "dmrs": mrs_reader,
                 "lfrg": lfrg_reader}
