# Reproduction of Experimental Results

## Overall Results

To reproduce the results in Section 3.2 (Figure 4 and Tabel 2), please follow the instructions below.

- The scripts used to conduct this part of experiments are in directory `benchmark`. There are 5 python scripts corresponding to each dataset.
```shell
cd benchmark
```

- At the end of each script, commands used to reproduct the corresponding experiment are included. Take CNN/DM as an example, run the following command to test Llama-70b/7b with Dual Decoding.
```shell
python test_cnndm.py --target_model <target_model_path> --draft_model <draft_model_path> --data_path <data_path> --dualdec --window_size 13 --guess_set_size 13 --lookahead_level 5 --gamma 4 --model_type chat
```

- Note: Now we are supporting local model path or huggingface identifier, and only local data paths are supported. Please refer to [Dataset Paths](#Datasets).

- For baseline measurements (Speculative and Lookahead Decoding), please `cd baselines` and commands are included at the end of each python script.

## Ablations

- Table 3 components of Dual Decoding: run `ablations/test_humen_eval.py` and use `--target_gen_ngram, --target_guess, --update_in_place_on` to control Candidate Inspiration, Candidate Suffixes and Candidate Refinement.
- Figure 5 top-k selection: run `ablations/test_humaneval.py` and use `--topk` to control the number of different $K$.
- Table 4 locality: run `ablations/text_locality.py` and use `--round, --each_num` to control the number of iterations among all datasets and Consecutive Number.
- Table 1 and Figure 3: run `ablations/test_mbpp.py`, `ablations/test_cnndm.py` and `ablations/test_wmt16.py`


## Datasets

- HumanEval: first download `HumanEval.jsonl.gz` from [here](https://github.com/declare-lab/instruct-eval/blob/main/human_eval/HumanEval.jsonl.gz), and point `data_path` to `HumanEval.jsonl.gz`.

- MBPP: Download Huggingface MBPP dataset from [here](https://huggingface.co/datasets/mbpp), and point `data_path` to the local dataset directory.

- GSM8K: Download Huggingface GSM8K dataset from [here](https://huggingface.co/datasets/DualAuthor/gsm8k_small), and point `data_path` to the local dataset directory.

- CNN/DM: Download Huggingface CNN/DM dataset from [here](https://huggingface.co/datasets/DualAuthor/cnndm_small), and point `data_path` to the local dataset directory.

- WMT16: Download Huggingface WMT16 dataset from [here](https://huggingface.co/datasets/DualAuthor/wmt16_small), and point `data_path` to the local dataset directory.

