import os
import jsonlines
import argparse
from openai import OpenAI
import openai

demonstrations_bengali = """
উদাহরণ:
১) প্রশ্ন: কটা শিরোনাম কাউন্টডাউন? <কলাম> বছর | শিরোনাম | ভূমিকা <রো ১> 2006 | সি নো ইভল | জেকব গুড নাইট <রো ২> 2006 | সি নো ইভল | জেকব গুড নাইট <রো ৩> 2006 | সি নো ইভল | জেকব গুড নাইট <রো ৪> 2010 | ম্যাকগ্রাবার | ট্যাংকার লুতিয <রো ৫> 2010 | ম্যাকগ্রাবার | ট্যাংকার লুতিয <রো ৬> 2010 | ম্যাকগ্রাবার | ট্যাংকার লুতিয <রো ৭> 2014 | স্কুবি-ডো! রেসলম্যানিয়া মিস্টরি | নিজে <রো ৮> 2014 | স্কুবি-ডো! রেসলম্যানিয়া মিস্টরি | নিজে <রো ৯> 2014 | স্কুবি-ডো! রেসলম্যানিয়া মিস্টরি | নিজে <রো ১০> 2014 | সী নো ইভল ২ | জেকব গুড নাইট <রো ১১> 2014 | সী নো ইভল ২ | জেকব গুড নাইট <রো ১২> 2014 | সী নো ইভল ২ | জেকব গুড নাইট <রো ১৩> 2016 | কাউন্টডাউন | লেঃ ক্রোনিন <রো ১৪> 2016 | কাউন্টডাউন | লেঃ ক্রোনিন <রো ১৫> 2016 | কাউন্টডাউন | লেঃ ক্রোনিন
   উত্তর: <কলাম> গণনা(`শিরোনাম`) <রো ১> ৩
২) প্রশ্ন: কটা বছরে শিরোনাম সি নো ইভল? <কলাম> বছর | শিরোনাম | ভূমিকা <রো ১> 2006 | সি নো ইভল | জেকব গুড নাইট <রো ২> 2006 | সি নো ইভল | জেকব গুড নাইট <রো ৩> 2006 | সি নো ইভল | জেকব গুড নাইট <রো ৪> 2010 | ম্যাকগ্রাবার | ট্যাংকার লুতিয <রো ৫> 2010 | ম্যাকগ্রাবার | ট্যাংকার লুতিয <রো ৬> 2010 | ম্যাকগ্রাবার | ট্যাংকার লুতিয <রো ৭> 2014 | স্কুবি-ডো! রেসলম্যানিয়া মিস্টরি | নিজে <রো ৮> 2014 | স্কুবি-ডো! রেসলম্যানিয়া মিস্টরি | নিজে <রো ৯> 2014 | স্কুবি-ডো! রেসলম্যানিয়া মিস্টরি | নিজে <রো ১০> 2014 | সী নো ইভল ২ | জেকব গুড নাইট <রো ১১> 2014 | সী নো ইভল ২ | জেকব গুড নাইট <রো ১২> 2014 | সী নো ইভল ২ | জেকব গুড নাইট <রো ১৩> 2016 | কাউন্টডাউন | লেঃ ক্রোনিন <রো ১৪> 2016 | কাউন্টডাউন | লেঃ ক্রোনিন <রো ১৫> 2016 | কাউন্টডাউন | লেঃ ক্রোনিন
   উত্তর: <কলাম> গণনা(`বছর`) <রো ১> ৩
"""
bengali_instruction = "আপনি একজন সহায়ক সহকারী যিনি বাংলা প্রশ্নের উত্তর দেন বাংলা টেবিল থেকে বাংলায় উত্তর টেবিল তৈরি করে।m সারি এবং n কলামগুলির একটি টেবিল নিম্নলিখিত প্যাটার্নে লেখা হয়ে: <কলাম> টেবিল হেডার <রো  ১> মান ১,১ | মান ১,২ | .... | মান ১,n <রো  ২> মান ২,১ | .... <রো m> মান m,১ | মান m,২ | .... | মান m,n"

demonstrations_hindi = """
उदाहरण:
१) सवाल: उन राजनेताओं की संख्या गिनें जिनका चुनावी वर्ष "2019" है। <कलाम> चुनाव वर्ष | विधायक | राजनीतिक दल <रो १> 2019 | सबिता महतो | झारखंड मुक्ति मोर्चा <रो २> 2019 | सबिता महतो | झारखंड मुक्ति मोर्चा <रो ३> 2019 | सबिता महतो | झारखंड मुक्ति मोर्चा <रो ४> 2014[2] | साधु चरण महतो | भारतीय जनता पार्टी <रो ५> 2014[2] | साधु चरण महतो | भारतीय जनता पार्टी <रो ६> 2014[2] | साधु चरण महतो | भारतीय जनता पार्टी <रो ७> 2009[3] | अरविंद कुमार सिंह | झारखण्ड विकास मोर्चा (प्रजातांत्रिक)'
   उत्तर: <कलाम> गणना(*) <रो १> ३
२) सवाल: उन टीमों में खिलाड़ियों की कुल संख्या कितनी है जो चेक गणराज्य, ऑस्ट्रिया में स्थित हैं? <कलाम> न. | स्कोर | खिलाड़ी | टीम | गेंदे | पारी | विपक्षी टीम | तारीख | परिणाम <रो १> 2 | 104* | सुदेश विक्रमसेकरा | चेक गणराज्य | 36 | 1 | तुर्की | 30 अगस्त 2019 | जीता[6] <रो २> 2 | 104* | सुदेश विक्रमसेकरा | चेक गणराज्य | 36 | 1 | तुर्की | 30 अगस्त 2019 | जीता[6] <रो ३> 2 | 104* | सुदेश विक्रमसेकरा | चेक गणराज्य | 36 | 1 | तुर्की | 30 अगस्त 2019 | जीता[6] <रो ४> 2 | 104* | सुदेश विक्रमसेकरा | चेक गणराज्य | 36 | 1 | तुर्की | 30 अगस्त 2019 | जीता[6] <रो ५> 2 | 104* | सुदेश विक्रमसेकरा | चेक गणराज्य | 36 | 1 | तुर्की | 30 अगस्त 2019 | जीता[6] <रो ६> 2 | 104* | सुदेश विक्रमसेकरा | चेक गणराज्य | 36 | 1 | तुर्की | 30 अगस्त 2019 | जीता[6] <रो ७> 2 | 104* | सुदेश विक्रमसेकरा | चेक गणराज्य | 36 | 1 | तुर्की | 30 अगस्त 2019 | जीता[6] <रो ८> 2 | 104* | सुदेश विक्रमसेकरा | चेक गणराज्य | 36 | 1 | तुर्की | 30 अगस्त 2019 | जीता[6] <रो ९> 2 | 104* | सुदेश विक्रमसेकरा | चेक गणराज्य | 36 | 1 | तुर्की | 30 अगस्त 2019 | जीता[6] <रो ९> 3 | 111* | बिलाल ज़ल्मई | ऑस्ट्रिया | 58 | 1 | चेक गणराज्य | 1 सितंबर 2019 | जीता[7] <रो १०> 3 | 111* | बिलाल ज़ल्मई | ऑस्ट्रिया | 58 | 1 | चेक गणराज्य | 1 सितंबर 2019 | जीता[7] <रो ११> 3 | 111* | बिलाल ज़ल्मई | ऑस्ट्रिया | 58 | 1 | चेक गणराज्य | 1 सितंबर 2019 | जीता[7] <रो १२> 3 | 111* | बिलाल ज़ल्मई | ऑस्ट्रिया | 58 | 1 | चेक गणराज्य | 1 सितंबर 2019 | जीता[7] <रो १३> 3 | 111* | बिलाल ज़ल्मई | ऑस्ट्रिया | 58 | 1 | चेक गणराज्य | 1 सितंबर 2019 | जीता[7] <रो १४> 3 | 111* | बिलाल ज़ल्मई | ऑस्ट्रिया | 58 | 1 | चेक गणराज्य | 1 सितंबर 2019 | जीता[7] <रो १५> 3 | 111* | बिलाल ज़ल्मई | ऑस्ट्रिया | 58 | 1 | चेक गणराज्य | 1 सितंबर 2019 | जीता[7] <रो १६> 3 | 111* | बिलाल ज़ल्मई | ऑस्ट्रिया | 58 | 1 | चेक गणराज्य | 1 सितंबर 2019 | जीता[7] <रो १७> 3 | 111* | बिलाल ज़ल्मई | ऑस्ट्रिया | 58 | 1 | चेक गणराज्य | 1 सितंबर 2019 | जीता[7]
   उत्तर: <कलाम> जोड़(`पारी`) <रो १> १८
"""
hindi_instruction = "आप एक सहायक हैं जो हिन्दी उत्तर तालिकाएँ बनाकर हिन्दी प्रश्नों के उत्तर देते हैं। m सारी एवं n कॉलमगुलियों की एक टेबल निम्नलिखित पैटर्न में लिखी जाती है: <कॉलम> टेबल हेडर <रो ১> मान १,१ | मान १,२ | .... | मान १,n <रो ২> मान २,१ | मान २,२ | .... | मान २,n ... <<रो > मान m,१ | मान m,२ | .... | मान m,n"

parser = argparse.ArgumentParser()
parser.add_argument("--batch_size", default=1, type=int, help="inference batch size")
parser.add_argument("--cpu", action='store_true', help="Load the model in cpu")
parser.add_argument("--pretrained_model_name", default=None, type=str,
                    help="huggingface pretrained language model name or local path to language model")
parser.add_argument("--generation_max_length", type=int, default=1024, help="max generation sequence length")
parser.add_argument("--validation_dataset_path", type=str, default=None,
                    help="path to validation dataset in huggingface Dataset format")
parser.add_argument("--predictions_save_path", type=str, help="path for predictions to be saved in")
parser.add_argument("--language", type=str, default="bn", help="language of questions and tables. Options: [bn, hi]")
parser.add_argument("--gpt_model_name", type=str, default="gpt-4", help="language of questions and tables. Options: [gpt-4, gpt-3.5-turbo-1106]")
args = parser.parse_args()

if args.language == "hi":
    instruction = hindi_instruction
    demonstrations = demonstrations_hindi
    question_token = "सवाल"
    answer_token = "उत्तर"
elif args.language == "bn":
    instruction = bengali_instruction
    demonstrations = demonstrations_bengali
    question_token = "প্রশ্ন"
    answer_token = "উত্তর"

openai.api_key = os.getenv("OPENAI_API_KEY")
openai.organization = os.getenv("OPENAI_ORG")
client = OpenAI(
    api_key=os.environ.get("OPENAI_API_KEY"),
)

with jsonlines.open(args.predictions_save_path, "w", flush=True) as f, jsonlines.open(
        args.validation_dataset_path) as f_val:
    for i, sample in enumerate(f_val):
        response = client.chat.completions.create(
            model=args.gpt_model_name,
            messages=[
                {"role": "system", "content": f"{instruction}\n{demonstrations}"},
                {"role": "user", "content": f':{question_token}: {sample["source"]}\n{answer_token}: '},
            ],
            temperature=0,
            max_tokens=1024
        )
        status_code = response.choices[0].finish_reason
        print(f"response: {response.choices[0].message.content}")
        print(f"status code: {status_code}")
        f.write({"source": sample["source"], "target": sample["target"],
                 "prediction": response.choices[0].message.content})
