## General
### Model

- `archive`: /mnt/16t/yunzhi/EasyEdit/results/models/MEND/llama2-7b-chat-recent
- `alg_name`: "MEND"
- `device`: 0
- `model_name`: ../hugging_cache/llama2-7b-chat
- `model_class`: LlamaForCausalLM
- `tokenizer_class`: LlamaTokenizer
- `tokenizer_name`: ../hugging_cache/llama2-7b-chat
- `inner_params`: Specifies the layer to be edited, like `model.layers.29.mlp.gate_proj.weight` and `model.layers.29.mlp.up_proj.weight`.

### Method
- `alg`: MEND
- `lr`: 1e-6
- `edit_lr`: 1e-4
- `lr_lr`: 1e-4
- `lr_scale`: 1.0
- `seed`: 42
 
- `cedit`: 0.1
- `cloc`: 1.0
- `cbase`: 1.0 #used to calculate loss
 
- `dropout`: 0.0
- `train_base`: False
- `no_grad_layers`: null
- `one_sided`: False
- `n_hidden`: 1
- `hidden_dim`: null
- `init`: id
- `norm`: True
- `combine`: True
- `x_only`: False
- `delta_only`: False
- `act`: relu
- `rank`: 1920
- `mlp_class`: IDMLP
- `shared`: True

### Train
- `batch_size`: 1
- `model_save_pt`: 5000
- `silent`: False
- `max_epochs`: 1
- `max_iters`: 100000
- `log_interval`: 1000
- `eval_log_interval`: 1000
- `final_eval`: True
- `val_interval`: 1000
- `early_stop_patience`: 20000
- `early_stop_key`: "loss/total_edit_val"
- `eval_only`: True
- `half`: False
- `debug`: False
- `save`: False
- `verbose`: True

- `val_batch_size`: 5
- `accumulate_bs`: 10
- `val_steps`: 500 # only for debug
- `opt`: Adam
- `grad_clip`: 100.
- `max_length`: 128

### Output

- `results_dir`: ./results

## Multimodal
- `qformer_checkpoint`: Specifies the checkpoint file for QFormer used in the model. Example: `hugging_cache/blip2_pretrained_flant5xxl.pth`.

- `qformer_name_or_path`: Provides the name or path of the pre-trained QFormer model. This could be a name of a pre-trained model from the model hub or a local path to the model. Example: `bert-base-uncased` or `./local/path/to/model`.

- `state_dict_file`: Specifies the checkpoint file for the Vision Transformer (ViT) used as the vision encoder. Example: `hugging_cache/eva_vit_g.pth`.

### image
- `coco_image`:  The directory storing the COCO dataset. We can access specific images by appending the image path to this directory, like `coco_image + "val2014/COCO_val2014_000000451435.jpg"`.
- `rephrase_image`: The directory storing rephrase images generated by the diffusion model based on COCO. Specific images can be accessed by appending the image path to this directory, like `rephrase_image + "val2014_image_rephrase/451435003_COCO_val2014_000000451435.png"`