# 8월 버전입니다. 추후 사용할 때 수정할 예정입니다.
def log_rank_test(N1: NumColumn, N2: NumColumn, O1: NumColumn, O2: NumColumn):
    # Only taking the first block of each column
    for a, b, c, d, v in zip(N1.data, N2.data, O1.data, O2.data, N1.vbit):
        block_n1 = a
        block_n2 = b
        block_o1 = c
        block_o2 = d
        block_vbit = v
        break

    block_n = block_n1 + block_n2
    block_n_minus = block_n - 1
    block_o = block_o1 + block_o2

    block_n_inv = block_n.inverse()
    block_n_minus *= block_vbit
    block_n_minus_inv = block_n_minus.inverse()

    block_e = block_n1 * block_o * block_n_inv

    block_v = block_e * block_n_inv
    block_v *= block_n - block_o
    block_v *= block_n_minus_inv

    block_v *= block_n2

    block_numer = block_o1 - block_e
    block_numer *= block_numer

    block_numer = __rotate_sum(block_numer)
    block_denom = __rotate_sum(block_v)

    block_out = Block.zeros(N1.context)

    block_out += block_numer * Block.oneone(N1.context, 0)
    block_out += block_denom * Block.oneone(N1.context, 1)

    return block_out


def run_test(column: NumColumn):

    # version 1
    num_rows = column.num_rows
    num_slots = column.context.num_slots
    num_blocks = len(column.data)

    block_0_1 = Block(column.context, [0] * (num_slots - 1) + [1])
    block_1_0 = Block(column.context, [1] * (num_slots - 1) + [0])

    block_0_1_list = []
    block_1_0_list = []

    for data_block in column.data:

        rotated_block = data_block << 1

        block_tmp_0_1 = rotated_block * block_0_1
        block_0_1_list.append(block_tmp_0_1)

        block_tmp_1_0 = rotated_block * block_1_0
        block_1_0_list.append(block_tmp_1_0)

    n_runs_block = Block.zeros(column.context)
    for idx, data_block in enumerate(column.data):

        tmp_block = block_1_0_list[idx] + block_0_1_list[(idx + 1) % num_blocks]
        sub_block = data_block - tmp_block
        n_runs_block += sub_block * sub_block

    n_runs_block = __rotate_sum(n_runs_block) + 1

    n1_block = sum(column)
    n2_block = n1_block * (-1) + num_rows

    expected_n_runs_block = n1_block * n2_block * 2
    expected_n_runs_block *= 1 / num_rows
    expected_n_runs_block += 1

    tmp1_block = n1_block * (1 / num_rows)
    tmp1_block = tmp1_block.sqrt_inv(one_slot=True)

    tmp2_block = n2_block * (1 / num_rows)
    tmp2_block = tmp2_block.sqrt_inv(one_slot=True)

    tmp3_block = n1_block * n2_block * 2 - n1_block - n2_block
    tmp3_block *= 1 / (2 * num_rows * (num_rows + 1))
    tmp3_block = tmp3_block.sqrt_inv(one_slot=True)

    res_block = n_runs_block - expected_n_runs_block
    res_block *= tmp1_block
    res_block *= tmp2_block
    res_block *= tmp3_block
    if res_block.need_bootstrap(5):
        res_block.bootstrap()
    res_block *= 1 / (2 * math.sqrt(num_rows))
