#!/bin/zsh

# 获取参数
PROGRAM=$1
NUM_EXAMPLES=${2:-5}
MODEL_NAME=${3:-llama2}
FEW_SHOT=${4:-False}
COT=${5:-False}

cat > mapping_evaluation_with_args.sh << EOF
#!/bin/zsh
#PJM -L rscgrp=share
#PJM -L gpu=4
#PJM -L elapse=10:00:00
#PJM -g gk77
#PJM -j
#PJM -N mapping_${PROGRAM}_${MODEL_NAME}_${FEW_SHOT}_${COT}
#PJM -o mapping_${PROGRAM}_${MODEL_NAME}_${FEW_SHOT}_${COT}
#PJM -e mapping_${PROGRAM}_${MODEL_NAME}_${FEW_SHOT}_${COT}

if [ -z "$RUN_ON_REMOTE" ]; then
    source /work/gk77/k77025/.zshrc
fi
PARAMS=(${@})

PROGRAM=${PARAMS[0]}
NUM_EXAMPLES=${PARAMS[1]:-5}
MODEL_NAME=${PARAMS[2]:-llama2}
FEW_SHOT=${PARAMS[3]:-False}
COT=${PARAMS[4]:-False}

case $PROGRAM in
"instruction")
python main_mapping.py --num_examples $NUM_EXAMPLES --model_name $MODEL_NAME --few_shot $FEW_SHOT --cot $COT
;;
"inducting")
python main_mapping_inducting.py --num_examples $NUM_EXAMPLES --model_name $MODEL_NAME --few_shot $FEW_SHOT --cot $COT
;;
"error_correction")
python main_mapping_error_correction.py --num_examples $NUM_EXAMPLES --model_name $MODEL_NAME --few_shot $FEW_SHOT --cot $COT
;;
"incorporating")
python main_mapping_rules_incorporating.py --num_examples $NUM_EXAMPLES --model_name $MODEL_NAME --few_shot $FEW_SHOT --cot $COT
;;
"validating")
python main_mapping_result_validating.py --num_examples $NUM_EXAMPLES --model_name $MODEL_NAME --few_shot $FEW_SHOT --cot $COT
;;
*)
echo "Unknown program: $PROGRAM"
echo "Usage: $0 {grouping|inducting|error_correction|incorporating|validating}"
exit 1
esac
EOF
# 提交脚本
pjsub mapping_evaluation_with_args.sh