# 8월 버전입니다. 추후 사용할 때 수정할 예정입니다.
def proportion_ztest(column: NumColumn, p_0: float = 0.5):
    block_count = count(column)
    block_count_inv = __safe_inverse(block_count, column.num_rows)
    block_sum = sum(column)
    block_avg = block_sum * block_count_inv

    z_block = block_avg - p_0
    z_block *= 1 / (math.sqrt(p_0 * (1 - p_0)))

    block_count_resize = block_count * (1 / column.num_rows)
    block_count_resize_sqrt = block_count_resize.sqrt()
    block_count_sqrt = block_count_resize_sqrt * math.sqrt(column.num_rows)

    z_block *= block_count_sqrt

    return z_block


def t_value3(column: NumColumn, hypo: NumColumn) -> Block:
    res_column = column.normalize(type=NormType.ZERO_ONE)

    block_sum = sum(res_column)
    block_count = count(column)
    block_count_minus = block_count - 1
    block_count_inv = __safe_inverse(block_count, column.num_rows)
    block_avg = block_sum * block_count_inv

    block_de = Block.zeros(column.context, encrypted=True)
    if column.has_vbit():
        for data_block, vbit_block in zip(res_column.data, res_column.vbit):
            tmp = data_block - block_avg
            tmp *= vbit_block
            tmp *= tmp
            block_de += tmp
    else:
        for data_block in zip(column.data):
            tmp = data_block - block_avg
            tmp *= tmp
            block_de += tmp

    block_de = __rotate_sum(block_de)
    block_count_minus_inv = __safe_inverse(block_count_minus, column.num_rows)
    block_de *= block_count_minus_inv  # block_de = var

    if block_de.need_bootstrap(6):
        block_de.bootstrap(one_slot=True)
    block_de = block_de.sqrt_inv(one_slot=True)  # block_de = 1/std

    block_count_normalized = block_count * (1 / column.num_rows)  # Normalizing n and finding sqrt(n)
    if block_count_normalized.need_bootstrap():
        block_count_normalized.bootstrap(one_slot=True)
    block_count_rt = block_count_normalized.sqrt(one_slot=True)
    block_count_rt *= column.num_rows ** (0.5)

    block_de *= block_count_rt  # block_de = sqrt(n)/std

    # Extracting the first block of hypo. Only loops once.
    for hypo_block in hypo.data:
        norm_hypo_block = hypo_block - column.min
        norm_hypo_block *= column.range_inv  # Normalizing the hypothesis mean
        block_t = block_avg - norm_hypo_block
        break

    block_t *= block_de

    # Return
    # block_t : t-value
    # block_count_minus : deg of freedom (parameter for t table)
    return block_t


def t_value_verbose(column: NumColumn, hypo: NumColumn) -> Block:
    res_column = column.normalize(type=NormType.ZERO_ONE)

    block_out = Block.zeros(column.context)

    block_sum = sum(res_column)
    block_count = count(column)
    block_count_minus = block_count - 1
    block_count_inv = __safe_inverse(block_count, column.num_rows)
    block_avg = block_sum * block_count_inv

    block_out += block_count_inv * Block.oneone(column.context, 2)
    block_out += block_avg * Block.oneone(column.context, 3)

    block_de = Block.zeros(column.context, encrypted=True)
    if column.has_vbit():
        for data_block, vbit_block in zip(res_column.data, res_column.vbit):
            tmp = data_block - block_avg
            tmp *= vbit_block
            tmp *= tmp
            block_de += tmp
    else:
        for data_block in zip(column.data):
            tmp = data_block - block_avg
            tmp *= tmp
            block_de += tmp

    block_de = __rotate_sum(block_de)
    block_count_minus_inv = __safe_inverse(block_count_minus, column.num_rows)
    block_de *= block_count_minus_inv  # block_de = var

    block_out += block_de * Block.oneone(column.context, 4)

    if block_de.need_bootstrap(6):
        block_de.bootstrap(one_slot=True)
    block_de = block_de.sqrt_inv(one_slot=True)  # block_de = 1/std

    block_out += block_de * Block.oneone(column.context, 5)

    block_count_normalized = block_count * (1 / column.num_rows)  # Normalizing n and finding sqrt(n)
    if block_count_normalized.need_bootstrap():
        block_count_normalized.bootstrap(one_slot=True)
    block_count_rt = block_count_normalized.sqrt(one_slot=True)
    block_count_rt *= column.num_rows ** (0.5)

    block_out += block_count_rt * Block.oneone(column.context, 6)

    block_de *= block_count_rt  # block_de = sqrt(n)/std

    block_out += block_de * Block.oneone(column.context, 7)

    # Extracting the first block of hypo. Only loops once.
    for hypo_block in hypo.data:
        norm_hypo_block = hypo_block - column.min
        norm_hypo_block *= column.range_inv  # Normalizing the hypothesis mean
        block_t = block_avg - norm_hypo_block
        block_out += column.range_inv * Block.oneone(column.context, 8)
        break

    block_out += block_t * Block.oneone(column.context, 1)
    block_t *= block_de

    block_out += block_t * Block.oneone(column.context, 0)
    # Return
    # block_t : t-value
    # block_count_minus : deg of freedom (parameter for t table)
    return block_out
