import os
import sys

def saveTxt(datas, fname):
    with open(fname, 'w') as fout:
        for data in datas:
            fout.write(data + '\n')
    print("save {} lines to {}".format(len(datas), fname))

datadir = sys.argv[1]
input_name = sys.argv[2]

datas = []

for field in ['doc', 'sum']:
    filename = input_name.replace("*", field)
    with open(os.path.join(datadir, filename), 'r') as fin:
        datas.append([line.strip() for line in fin])

results = []

documents = []
summaries = []
for doc, summ in zip(*datas):
    if doc != "" and summ != "":
        documents.append(doc)
        summaries.append(summ)

saveTxt(documents, os.path.join(
    datadir, input_name.replace('*', 'doc') + ".noempty"
))

saveTxt(summaries, os.path.join(
    datadir, input_name.replace('*', 'sum') + ".noempty"
))
