#!/usr/bin/env bash

DIR="/home/tiger/MSPM"
# LANG="de en fr zh ru"

get_seeded_random()
{
  seed="$1"
  openssl enc -aes-256-ctr -pass pass:"$seed" -nosalt \
    </dev/zero 2>/dev/null
}

mkdir $DIR/EnFr

cat $DIR/en/train.en.spm.doc $DIR/fr/train.fr.spm.doc > $DIR/EnFr/train.noshuffle.spm.doc
cat $DIR/en/train.en.spm.sum $DIR/fr/train.fr.spm.sum > $DIR/EnFr/train.noshuffle.spm.sum
echo "shuffling"
shuf --random-source=<(get_seeded_random 66) $DIR/EnFr/train.noshuffle.spm.doc > $DIR/EnFr/train.EnFr.spm.doc
shuf --random-source=<(get_seeded_random 66) $DIR/EnFr/train.noshuffle.spm.sum > $DIR/EnFr/train.EnFr.spm.sum

cat $DIR/en/dev.en.spm.doc $DIR/fr/dev.fr.spm.doc > $DIR/EnFr/dev.noshuffle.spm.doc
cat $DIR/en/dev.en.spm.sum $DIR/fr/dev.fr.spm.sum > $DIR/EnFr/dev.noshuffle.spm.sum
echo "shuffling"
shuf --random-source=<(get_seeded_random 66) $DIR/EnFr/dev.noshuffle.spm.doc > $DIR/EnFr/dev.EnFr.spm.doc
shuf --random-source=<(get_seeded_random 66) $DIR/EnFr/dev.noshuffle.spm.sum > $DIR/EnFr/dev.EnFr.spm.sum
