#!/bin/bash

seeds=(2394475620 1251937227 3563950613 436439405 2955867855)
TASK="cola"
SAVE_PATH="/tmp/"
PRUNING="Layer" # Layer/ Weight/ Neuron
TASKS=("cola" "rte" "sst2" "mrpc" "stsb" "qnli" "qqp" "mnli")
#[\"cola\", \"rte\", \"sst2\", \"mrpc\", \"stsb\", \"qnli\", \"qqp\", \"mnli\"]
get_config(){
CONFIG_TMP="model:
  adapter_path: \"./adapter_for_af\"
  pruning_strategy: \"$3\"
  af_adapters: [\"$4\"] 
  save_model_path: \"${SAVE_PATH}\"
  cal_imp: False
  imp_training: False
  cal_flops: True
  do_train: True
  save_eval: False
  gen_submit: False
  do_eval: False
train:
  task: \"$4\"
  lr: 5e-5
  seeds: $2
  epochs: 4
"
cat << EOF > $1
$CONFIG_TMP
EOF
}


run_training() {
    mkdir -p "configs/$3/$2/$1"
    config_file="configs/$3/$2/$1/config.yml" 
    get_config ${config_file} $1 $2 $3 
    python main.py -c ${config_file} train
}

run_count=8
run_index=0
while (( "$run_index" < "$run_count" ))
do
    # echo ${seeds[$run_index]}
    run_training ${seeds[0]} "Layer" ${TASKS[$run_index]}
    #run_training ${seeds[$run_index]} "Layer" ${TASK}
    run_index=$[run_index+1]
done

#       origin     LTH         AdapterDrop
# SST2 95436447744 92737413120 93360267264
# CoLA                         62103748608
# 
