
source ./env/bin/activate

for topic in climate-change corporate-tax drug-policy gay-marriage obamacare
do
    for model in roberta-base bert-base-cased bert-base-uncased
    do
        echo "$topic $model"
        python ./main.py --seed=42 --model_dataset=$topic --task=train_classifier --output_dir=./model/$model/model_$topic/42/all --data_dir=./data/data_$topic --model_type=bert --model_name_or_path=$model --do_train --do_eval --loss_type=class --overwrite_output_dir --dataset=all --augment_type=original --per_device_train_batch_size=16 --num_train_epochs=3
        rm -rf ./model/$model/model_$topic/42/all/class/original/checkpoint-*
    done
done

for topic in climate-change corporate-tax drug-policy gay-marriage obamacare
do
    for model in roberta-base bert-base-cased bert-base-uncased
    do
        for dataset in Breitbart CBS CNN Fox HuffPost NPR NYtimes usatoday wallstreet washington
        do
            for aug in original
            do
                echo "$topic $model $dataset $aug"
                python ./main.py --seed=42 --model_dataset=$topic --task=encode_media --output_dir=./model/$model/model_$topic/42/all --data_dir=./data/data_$topic --model_type=bert --model_name_or_path=$model --do_eval --loss_type=class --line_by_line --overwrite_output_dir --dataset=$dataset --augment_type=$aug --multiple_number=1
            done
        done
    done
done