from overrides import overrides

from allennlp.common.util import JsonDict
from allennlp.data import Instance
from allennlp.predictors.predictor import Predictor


@Predictor.register("mbart")
class Seq2SeqMBARTPredictor(Predictor):
    """
    Predictor for vector to sequence models
    """

    @overrides
    def _json_to_instance(self, json_dict: JsonDict) -> Instance:
        """
        Expects JSON that looks like `{"source": "...", 'vec': "..."}`.
        """
        source = json_dict["source"]
        source_lang = json_dict['source_lang']
        return self._dataset_reader.text_to_instance(source_string=source, source_lang=source_lang)
