#!/bin/bash
workdir=./


log_signature=$1
data_source=$2
ref_lang=$3

hyp_file=${workdir}/output/at_output/${data_source}/temp_${log_signature}.txt
ref=$workdir/data-bin/${data_source}_ori/test.${ref_lang}.official.delbpe

python $workdir/scripts/order_res.py ${hyp_file}
bash $workdir/scripts/delbpe.sh ${hyp_file}.ordered

perl -ple 's{(\S)-(\S)}{$1 ##AT##-##AT## $2}g' < $ref > ${ref}.atat
perl -ple 's{(\S)-(\S)}{$1 ##AT##-##AT## $2}g' < ${hyp_file}.ordered.delbpe > ${hyp_file}.ordered.delbpe.atat
$workdir/scripts/multi-bleu.perl ${ref}.atat < ${hyp_file}.ordered.delbpe.atat