
for seed in 40 41 42 43 44; do
    for model_type in "m1" "m3" "baseline"; do
        for dataset in "tacred_revised"; do
            export SEED=${seed}
            export SYNTAX_MODEL_TYPE=${model_type}
            export DATASET_NAME=${dataset}
            COMMON_ARGS="--account=rrg-bengioy-ad_gpu --time=20:00:0 --gres=gpu:v100:1 -c 4 --mem=32G --export=SEED,SYNTAX_MODEL_TYPE,DATASET_NAME --output=logs/tacred/no_deptree_pruning/${DATASET_NAME}_${SYNTAX_MODEL_TYPE}_${SEED}.out"
            sbatch ${COMMON_ARGS} --job-name=${DATASET_NAME}_${SYNTAX_MODEL_TYPE}_${SEED} slurm_job_cc_relext.sh
        done
    done
done
