function vec = lincomb(M, x, vecs, coeffs)
% Computes a linear combination of tangent vectors in the Manopt framework.
%
% vec = lincomb(M, x, vecs, coeffs)
%
% M is a Manopt manifold structure obtained from a factory.
% x is a point on the manifold M.
% vecs is a cell containing n tangent vectors at x.
% coeffs is a vector of length n
%
% vec is a tangent vector at x obtained as the linear combination
%
%    vec = coeffs(1)*vecs{1} + ... + coeffs(n)*vecs{n}
%
% If vecs is an orthonormal basis, then tangent2vec is the inverse of
% lincomb.
%
% See also: grammatrix orthogonalize tangentorthobasis tangent2vec

% This file is part of Manopt: www.manopt.org.
% Original author: Nicolas Boumal, April 28, 2016.
% Contributors: 
% Change log: 


    n = numel(vecs);
    assert(numel(coeffs) == n);
    
    switch n
       
        case 0
            
            vec = M.zerovec(x);
            
        case 1
            
            vec = M.lincomb(x, coeffs(1), vecs{1});
            
        otherwise
            
            vec = M.lincomb(x, coeffs(1), vecs{1}, coeffs(2), vecs{2});
            
            for k = 3 : n
                
                vec = M.lincomb(x, 1, vec, coeffs(k), vecs{k});
                
            end
        
    end
        

end
