###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#! /opt/gnu/bin/perl

################################################################################
#
#  dotreerow -- traverse the tree in flattened right-branching rows...
#               uses $rest to keep track of where it is...
#
################################################################################

sub dotreerow {

  ##### DO SOMETHING at beginning of constituent...
  my @Params = @_;
  my $child;
  my @RowChild;
  my @RowStep;
  my $out;

  ##### Process the category label at the top of the row (label will be $1)...
  if ( $rest =~ /^([^\[\] ]*) */ ) {
    ##### Consume label...
    $rest = $' ;
    ##### DO SOMETHING with the category (nonterminal) label...
    $RowStep[$child] = $1;
  }


  ##### Process complex row child node...
  if ( $rest =~ /^\[ */ ) {
    ##### Consume open bracket delimiters...
    $rest = $' ;
    $RowChild[$child++] = dotreerow ( ) ;
  }
  ##### Process word row child (label will be $1)...
  elsif ( $rest =~ /^([^\[\] ]+) */ ) {
    ##### Consume label...
    $rest = $' ;
    ##### DO SOMETHING with the word (leaf) label...
    $RowChild[$child++] = $1;
  }

  ##### Process the rest of the row...
  while ( $rest =~ /^\[ */ ) {

    ##### Process the intermediate label in the row (label will be $1)...
    if ( $rest =~ /^\[ *([^\[\] ]*) */ ) {
      ##### Consume open bracket and label...
      $rest = $' ;
      ##### DO SOMETHING with the category (nonterminal) label...
      $RowStep[$child] = $1;
    }

    ##### Process complex row child node...
    if ( $rest =~ /^\[ */ ) {
      ##### Consume open bracket...
      $rest = $' ;
      $RowChild[$child++] = dotreerow ( ) ;
    }
    ##### Process word row child (label will be $1)...
    elsif ( $rest =~ /^([^\[\] ]+) */ ) {
    ##### Consume label...
      $rest = $' ;
      ##### DO SOMETHING with the word (leaf) label...
      $RowChild[$child++] = $1;
    }
  }

  ##### Process rightmost word row child (label will be $1)...
  if ( $rest =~ /^([^\[\] ]+) */ ) {
    ##### Consume label...
    $rest = $' ;
    ##### DO SOMETHING with the word (leaf) label...
    $RowStep[$child] = $1;
    $RowChild[$child++] = $1;
  }

  ##### Process close brackets (they'll all be together)...
  while ( $rest =~ /^\] */ ) {
    ##### Consume close bracket delimiter...
    $rest = $' ;
  }


  ##### DO SOMETHING at end of row: print row steps and children...
  # If unary...
  if ($child==1) {
    $out = "\[$RowStep[0] $RowChild[0]\]";
  }
  # If binary or more...
  else {
    # Print row steps...
    $out = "\[$RowStep[0] ";
    for ($i=$child-1; $i>1; $i--) {
      $out = $out."\[$RowStep[0]/$RowStep[$i] ";
    }
    # Print row children...
    $out = $out." \[$RowStep[0]/$RowStep[1] $RowChild[0]\]";
    for ($i=1; $i<$child-1; $i++) {
      $out = $out." \[$RowStep[$i]/$RowStep[$i+1] $RowChild[$i]\]\]";
    }
    $out = $out." \[$RowStep[$i] $RowChild[$i]\]\]";
  }

  return $out ;
}

################################################################################

while ( <STDIN> ) {
  if ( $_ =~ /^[^\[\]]*\[/ ) {
    $rest = $' ;
    $out = dotreerow ( ) ;
    print "$out\n";
  }
}













