/*
 * Decompiled with CFR 0.152.
 */
package similarity;

import com.aliasi.matrix.SparseFloatVector;
import java.util.ArrayList;
import java.util.TreeMap;
import similarity.TokenDictionary;

public class SentTokenVector {
    private TokenDictionary tokenDict = null;
    private SparseFloatVector freqVector = null;
    private int id = -1;
    String sentText = null;

    public SentTokenVector(String string, TokenDictionary tokenDictionary, int n, boolean bl) {
        this.tokenDict = tokenDictionary;
        this.id = n;
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        ArrayList<String> arrayList = tokenDictionary.tokenize(string);
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            String string2 = object.next();
            Integer n2 = tokenDictionary.GetTokenId(string2);
            if (n2 == null) {
                System.out.println("SentTokenVector.SparseFloatVector: Warning: unknown token " + string2);
                System.out.println(string);
                continue;
            }
            Integer n3 = (Integer)treeMap.get(n2);
            if (n3 != null) {
                n3 = n3 + 1;
                treeMap.put(n2, n3);
                continue;
            }
            treeMap.put(n2, new Integer(1));
        }
        this.freqVector = object = new SparseFloatVector(treeMap, tokenDictionary.GetDictDimensions());
        if (bl) {
            this.sentText = string;
        }
    }

    public static SparseFloatVector ProcessSent(String string, TokenDictionary tokenDictionary) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        ArrayList<String> arrayList = tokenDictionary.tokenize(string);
        for (String string2 : arrayList) {
            Integer n = tokenDictionary.GetTokenId(string2);
            if (n == null) {
                System.out.println("SentTokenVector.SparseFloatVector: Warning: unknown token " + string2);
                System.out.println(string);
                continue;
            }
            Integer n2 = (Integer)treeMap.get(n);
            if (n2 != null) {
                n2 = n2 + 1;
                treeMap.put(n, n2);
                continue;
            }
            treeMap.put(n, new Integer(1));
        }
        SparseFloatVector sparseFloatVector = new SparseFloatVector(treeMap, tokenDictionary.GetDictDimensions());
        return sparseFloatVector;
    }

    public TokenDictionary getTokenDict() {
        return this.tokenDict;
    }

    public SparseFloatVector getFreqVector() {
        return this.freqVector;
    }

    public void setFreqVector(SparseFloatVector sparseFloatVector) {
        this.freqVector = sparseFloatVector;
    }

    public int getId() {
        return this.id;
    }

    public void PrintVector() {
        int[] nArray;
        StringBuilder stringBuilder = new StringBuilder("Sent " + String.valueOf(this.id));
        if (this.sentText != null) {
            stringBuilder.append(": " + this.sentText);
        }
        stringBuilder.append("\n");
        for (int n : nArray = this.freqVector.nonZeroDimensions()) {
            String string = this.tokenDict.GetTokenString(new Integer(n));
            stringBuilder.append("\t" + string + ": " + String.valueOf(this.freqVector.value(n)) + "\n");
        }
        System.out.println(stringBuilder.toString());
    }

    public void ApplyWeighting(int n, double d) {
    }
}

