/*
 * Decompiled with CFR 0.152.
 */
package wordModel;

import java.util.Arrays;
import wordModel.UkWordMapping;

public class UkWordMappingStd
extends UkWordMapping {
    static final String containsDigitMatch = ".*\\d.*";
    static final String containsAlphaMatch = ".*[a-zA-Z].*";
    boolean useFirstWord;
    boolean useFirstCap;
    boolean useAllCap;
    boolean useDash;
    boolean useForwardSlash;
    boolean useDigit;
    boolean useAlpha;
    boolean useDollar;
    String[] affixes;
    String[] suffixes;
    boolean allowToCombineSuffixAffix;
    boolean useASFixWithDash;
    boolean useASFixWithSlash;
    boolean useASFixWithCapital;
    int[][] affixesStats;
    int[][] suffixesStats;

    @Override
    protected void loadDefaultParameters() {
        this.useFirstWord = true;
        this.useFirstCap = true;
        this.useAllCap = false;
        this.useDash = true;
        this.useForwardSlash = true;
        this.useDigit = true;
        this.useAlpha = true;
        this.useDollar = false;
        this.allowToCombineSuffixAffix = false;
        this.useASFixWithDash = false;
        this.useASFixWithSlash = false;
        this.useASFixWithCapital = false;
        compareTrainTest = false;
        String suffixesAll = "ments ance dent ence ists line ment ship time ans ant are ate ble cal ess est ful ian ics ing ion ist ive man ons ory ous son tor ure al ce ck cy de ds ed er es et ey fy gs gy ic is ks ld le ls ly ne rd rs se sh sm th ts ty ze s y";
        this.affixes = null;
        this.suffixes = suffixesAll.split("\\s");
        if (this.affixes != null) {
            this.affixesStats = new int[2][this.affixes.length];
        }
        if (this.suffixes != null) {
            this.suffixesStats = new int[2][this.suffixes.length];
        }
    }

    @Override
    protected void printParametersInfo() {
        System.out.println("Unknown Word Threashold: " + ukThreashold);
        System.out.println("Total Affixes: " + (this.affixes == null ? 0 : this.affixes.length));
        System.out.println("Total Affixes: " + (this.affixes == null ? 0 : this.affixes.length));
        System.out.println(Arrays.toString(this.affixes));
        System.out.println("\n");
        System.out.println("Total Suffixes: " + (this.suffixes == null ? 0 : this.suffixes.length));
        System.out.println(Arrays.toString(this.suffixes));
        System.out.println("\n");
    }

    @Override
    protected void printModelStats() {
        int i;
        if (this.affixes != null) {
            System.out.println("AFFIXES:");
            i = 0;
            while (i < this.affixes.length) {
                System.out.println(String.valueOf(this.affixes[i]) + "\t" + this.affixesStats[0][i] + "\t" + this.affixesStats[1][i]);
                ++i;
            }
        }
        if (this.suffixes != null) {
            System.out.println("-----------------------------");
            System.out.println("SUFFIXES:");
            i = 0;
            while (i < this.suffixes.length) {
                System.out.println(String.valueOf(this.suffixes[i]) + "\t" + this.suffixesStats[0][i] + "\t" + this.suffixesStats[1][i]);
                ++i;
            }
        }
    }

    @Override
    public String getFeatureOfWord(String word, boolean firstWord, int trainingDevelop) {
        boolean hasDigit;
        StringBuilder result = new StringBuilder();
        if (this.useFirstWord) {
            result.append(firstWord ? "_1stY" : "_1stN");
        }
        boolean firstCapital = false;
        if (this.useFirstCap) {
            char firstChar = word.charAt(0);
            firstCapital = Character.isUpperCase(firstChar);
            result.append(firstCapital ? "_1capY" : "_1capN");
        }
        boolean allCapital = false;
        if (this.useAllCap) {
            allCapital = UkWordMappingStd.allCapitals(word);
            result.append(allCapital ? "_AcapY" : "_AcapN");
        }
        boolean hasDash = false;
        if (this.useDash) {
            hasDash = word.indexOf(45) != -1;
            result.append(hasDash ? "_dashY" : "_dashN");
        }
        boolean hasForwardSlash = false;
        if (this.useForwardSlash) {
            hasForwardSlash = word.indexOf(47) != -1;
            result.append(hasForwardSlash ? "_slshY" : "_slshN");
        }
        if (this.useDollar) {
            boolean hasDollar = word.indexOf(36) != -1;
            result.append(hasDollar ? "_$Y" : "_$N");
        }
        if (this.useAlpha) {
            hasDigit = word.matches(containsAlphaMatch);
            result.append(hasDigit ? "_alfY" : "_alfN");
        }
        if (this.useDigit) {
            hasDigit = word.matches(containsDigitMatch);
            result.append(hasDigit ? "_digY" : "_digN");
        }
        if (!(!this.useASFixWithDash && hasDash || !this.useASFixWithSlash && hasForwardSlash || !this.useASFixWithCapital && (firstCapital || allCapital))) {
            String wordLower = word.toLowerCase();
            boolean foundSuffix = false;
            if (this.suffixes != null) {
                String suff = this.getSuffix(wordLower, trainingDevelop);
                if (suff == null) {
                    result.append("_sfx:NONE");
                } else {
                    result.append("_sfx:" + suff);
                    foundSuffix = true;
                }
            }
            if (this.affixes != null) {
                if (!this.allowToCombineSuffixAffix && foundSuffix) {
                    result.append("_afx:NONE");
                } else {
                    String aff = this.getAffix(wordLower, trainingDevelop);
                    result.append(aff == null ? "_afx:NONE" : "_afx:" + aff);
                }
            }
        } else {
            result.append("_sfx:NONE");
            result.append("_afx:NONE");
        }
        return result.substring(1);
    }

    public static boolean allCapitals(String w) {
        char[] charArray;
        char[] cArray = charArray = w.toCharArray();
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isLowerCase(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String getAffix(String wordLower, int trainingDevelop) {
        int index = 0;
        String[] stringArray = this.affixes;
        int n = this.affixes.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (wordLower.startsWith(a)) {
                if (trainingDevelop >= 0) {
                    int[] nArray = this.affixesStats[trainingDevelop];
                    int n3 = index;
                    nArray[n3] = nArray[n3] + 1;
                }
                return a;
            }
            ++index;
            ++n2;
        }
        return null;
    }

    public String getSuffix(String wordLower, int trainingDevelop) {
        int index = 0;
        String[] stringArray = this.suffixes;
        int n = this.suffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (wordLower.endsWith(a)) {
                if (trainingDevelop >= 0) {
                    int[] nArray = this.suffixesStats[trainingDevelop];
                    int n3 = index;
                    nArray[n3] = nArray[n3] + 1;
                }
                return a;
            }
            ++index;
            ++n2;
        }
        return null;
    }
}

