class APCModelList(list):
    from .bert_spc import BERT_SPC
    from .bert_spc_v2 import BERT_SPC_V2
    from .fast_lcf_bert import FAST_LCF_BERT
    from .fast_lcfs_bert import FAST_LCFS_BERT
    from .fast_lsa_t_v2 import FAST_LSA_T_V2
    from .fast_lsa_s_v2 import FAST_LSA_S_V2

    FAST_LSA_T_V2 = FAST_LSA_T_V2
    FAST_LSA_S_V2 = FAST_LSA_S_V2

    FAST_LCF_BERT = FAST_LCF_BERT
    FAST_LCFS_BERT = FAST_LCFS_BERT

    BERT_SPC = BERT_SPC
    LSA_P_V2 = BERT_SPC_V2

    def __init__(self):
        model_list = [
            self.FAST_LSA_T_V2,
            self.FAST_LSA_S_V2,
            self.FAST_LCF_BERT,
            self.FAST_LCFS_BERT,
            self.BERT_SPC,
        ]
        super().__init__(model_list)
