/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.domains.ace.reader;

import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.process.AbstractTokenizer;
import edu.stanford.nlp.util.Generics;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RobustTokenizer<T extends Word>
extends AbstractTokenizer<Word> {
    String buffer;
    private AbbreviationMap mAbbreviations;
    public static final int MAX_MULTI_WORD_SIZE = 20;
    public static final String DOT = RobustTokenizer.block("\\.");
    public static final String DOTDOT = RobustTokenizer.block("\\:");
    public static final String APOSTROPHE = RobustTokenizer.block("\\'");
    public static final String SLASH = RobustTokenizer.block("\\/");
    public static final String UNDERSCORE = RobustTokenizer.block("\\_");
    public static final String MINUS = RobustTokenizer.block("\\-");
    public static final String PLUS = RobustTokenizer.block("\\+");
    public static final String COMMA = RobustTokenizer.block("\\,");
    public static final String DOTCOMMA = RobustTokenizer.block("\\;");
    public static final String QUOTES = RobustTokenizer.block(RobustTokenizer.or("\\\"", "\\'\\'", "\\'", "\\`\\`", "\\`"));
    public static final String DOUBLE_QUOTES = RobustTokenizer.block(RobustTokenizer.or("\\\"", "\\'\\'"));
    public static final String LRB = RobustTokenizer.block("\\(");
    public static final String RRB = RobustTokenizer.block("\\)");
    public static final String LCB = RobustTokenizer.block("\\{");
    public static final String RCB = RobustTokenizer.block("\\}");
    public static final String GREATER = RobustTokenizer.block("\\>");
    public static final String LOWER = RobustTokenizer.block("\\<");
    public static final String AMPERSAND = RobustTokenizer.block("\\&");
    public static final String AT = RobustTokenizer.block("\\@");
    public static final String HTTP = RobustTokenizer.block("[hH][tT][tT][pP]\\:\\/\\/");
    public static final String WHITE_SPACE = RobustTokenizer.block("\\s");
    public static final String DIGIT = RobustTokenizer.block("\\d");
    public static final String LETTER = RobustTokenizer.block("[a-zA-Z]");
    public static final String UPPER = RobustTokenizer.block("[A-Z]");
    public static final String SIGN = RobustTokenizer.or(MINUS, PLUS);
    public static final String FULLNUM = RobustTokenizer.block(RobustTokenizer.zeroOrOne(SIGN) + RobustTokenizer.oneOrMore(DIGIT) + RobustTokenizer.zeroOrMore(RobustTokenizer.zeroOrOne(RobustTokenizer.or(DOT, COMMA, SLASH)) + RobustTokenizer.oneOrMore(DIGIT)));
    public static final String DECNUM = RobustTokenizer.block(DOT + RobustTokenizer.oneOrMore(DIGIT));
    public static final String NUM = RobustTokenizer.or(FULLNUM, DECNUM);
    public static final String DATE = RobustTokenizer.block(RobustTokenizer.oneOrMore(DIGIT) + SLASH + RobustTokenizer.oneOrMore(DIGIT) + SLASH + RobustTokenizer.oneOrMore(DIGIT));
    public static final String TIME = RobustTokenizer.block(RobustTokenizer.oneOrMore(DIGIT) + RobustTokenizer.oneOrMore(RobustTokenizer.block(DOTDOT + RobustTokenizer.oneOrMore(DIGIT))));
    public static final String PUNC = RobustTokenizer.or(QUOTES, RobustTokenizer.block(MINUS + RobustTokenizer.oneOrMore(MINUS)), RobustTokenizer.block(DOT + RobustTokenizer.oneOrMore(DOT)));
    public static final String LETTERS = RobustTokenizer.oneOrMore(LETTER);
    public static final String BLOCK = RobustTokenizer.or(NUM, LETTERS);
    public static final String WORD = RobustTokenizer.block(RobustTokenizer.zeroOrOne(APOSTROPHE) + BLOCK + RobustTokenizer.zeroOrMore(RobustTokenizer.block(RobustTokenizer.zeroOrOne(RobustTokenizer.or(UNDERSCORE, MINUS, APOSTROPHE, SLASH, AMPERSAND)) + BLOCK)));
    public static final String ACRONYM = RobustTokenizer.block(RobustTokenizer.oneOrMore(LETTER + DOT));
    public static final String LOOSE_ACRONYM = RobustTokenizer.block(RobustTokenizer.oneOrMore(RobustTokenizer.oneOrMore(LETTER) + DOT) + RobustTokenizer.zeroOrMore(LETTER));
    public static final String PAREN = RobustTokenizer.or(LRB, RRB, LCB, RCB);
    public static final String SGML = "<[^<>]+>";
    public static final String HTMLCODE = RobustTokenizer.block(AMPERSAND + UPPER + DOTCOMMA);
    public static final String ANY = RobustTokenizer.block("\\S");
    public static final String EMAIL = RobustTokenizer.block(LETTER + RobustTokenizer.zeroOrMore(RobustTokenizer.or(LETTER, DIGIT, DOT, MINUS, UNDERSCORE)) + AT + RobustTokenizer.zeroOrMore(RobustTokenizer.or(LETTER, DIGIT, DOT, MINUS, UNDERSCORE)) + LETTER);
    public static final String DOMAIN_EMAIL = RobustTokenizer.block(LETTER + RobustTokenizer.zeroOrMore(RobustTokenizer.or(LETTER, DIGIT, DOT, MINUS, UNDERSCORE)) + AT + RobustTokenizer.oneOrMore(RobustTokenizer.or(LETTER, DIGIT, DOT, MINUS, UNDERSCORE)) + RobustTokenizer.zeroOrMore(WHITE_SPACE) + DOT + RobustTokenizer.zeroOrMore(WHITE_SPACE) + RobustTokenizer.or("org", "ORG", "com", "COM", "net", "NET", "ru", "us"));
    public static final String URL = RobustTokenizer.block(HTTP + RobustTokenizer.oneOrMore(RobustTokenizer.or(LETTER, DIGIT, DOT, UNDERSCORE, SLASH, AMPERSAND, MINUS, PLUS)));
    public static final String SMALL_URL = RobustTokenizer.block(RobustTokenizer.oneOrMore(RobustTokenizer.oneOrMore(LETTER) + DOT) + RobustTokenizer.zeroOrMore(WHITE_SPACE) + RobustTokenizer.or("org", "ORG", "com", "COM", "net", "NET", "ru", "us"));
    public static final String UNDERSCORESEQ = RobustTokenizer.oneOrMore("_");
    public static final String LIST_BULLET = RobustTokenizer.block(LRB + LETTER + RobustTokenizer.zeroOrOne(LETTER) + RRB);
    public static final String PHONE_PART = RobustTokenizer.block(LRB + RobustTokenizer.oneOrMore(DIGIT) + RRB);
    public static final String DIGITSEQ = RobustTokenizer.oneOrMore(DIGIT);
    public static final String RECOGNISED_PATTERN = RobustTokenizer.block(RobustTokenizer.block(TIME) + "|" + RobustTokenizer.block(DOMAIN_EMAIL) + "|" + RobustTokenizer.block(EMAIL) + "|" + RobustTokenizer.block(URL) + "|" + RobustTokenizer.block(ACRONYM) + "|" + RobustTokenizer.block(DATE) + "|" + RobustTokenizer.block(PHONE_PART) + "|" + RobustTokenizer.block(WORD) + "|" + RobustTokenizer.block(PUNC) + "|" + RobustTokenizer.block(LIST_BULLET) + "|" + RobustTokenizer.block(PAREN) + "|" + RobustTokenizer.block("<[^<>]+>") + "|" + RobustTokenizer.block(HTMLCODE) + "|" + RobustTokenizer.block(UNDERSCORESEQ) + "|" + RobustTokenizer.block(ANY));
    private static final Pattern wordPattern = Pattern.compile(RECOGNISED_PATTERN);
    private static final Pattern sgmlPattern = Pattern.compile("<[^<>]+>");
    private static final Pattern slashDatePattern = Pattern.compile(DATE);
    private static final Pattern acronymPattern = Pattern.compile(LOOSE_ACRONYM);
    private static final Pattern urlPattern = Pattern.compile(URL);
    private static final Pattern emailPattern = Pattern.compile(EMAIL);
    private static final Pattern digitSeqPattern = Pattern.compile(DIGITSEQ);
    Word[] cachedTokens;
    int cachedPosition;

    public RobustTokenizer(String buffer) {
        this.mAbbreviations = new AbbreviationMap(true);
        this.buffer = buffer;
        this.cachedTokens = null;
    }

    public RobustTokenizer(boolean caseInsensitive, String buffer) {
        this.mAbbreviations = new AbbreviationMap(caseInsensitive);
        this.buffer = buffer;
        this.cachedTokens = null;
    }

    public static String range(String s) {
        return RobustTokenizer.block("[" + s + "]");
    }

    public static String zeroOrOne(String s) {
        return RobustTokenizer.block(RobustTokenizer.block(s) + "?");
    }

    public static String zeroOrMore(String s) {
        return RobustTokenizer.block(RobustTokenizer.block(s) + "*");
    }

    public static String oneOrMore(String s) {
        return RobustTokenizer.block(RobustTokenizer.block(s) + "+");
    }

    public static String block(String s) {
        return "(" + s + ")";
    }

    public static String or(String s1, String s2) {
        return RobustTokenizer.block(RobustTokenizer.block(s1) + "|" + RobustTokenizer.block(s2));
    }

    public static String or(String s1, String s2, String s3) {
        return RobustTokenizer.block(RobustTokenizer.block(s1) + "|" + RobustTokenizer.block(s2) + "|" + RobustTokenizer.block(s3));
    }

    public static String or(String s1, String s2, String s3, String s4) {
        return RobustTokenizer.block(RobustTokenizer.block(s1) + "|" + RobustTokenizer.block(s2) + "|" + RobustTokenizer.block(s3) + "|" + RobustTokenizer.block(s4));
    }

    public static String or(String s1, String s2, String s3, String s4, String s5) {
        return RobustTokenizer.block(RobustTokenizer.block(s1) + "|" + RobustTokenizer.block(s2) + "|" + RobustTokenizer.block(s3) + "|" + RobustTokenizer.block(s4) + "|" + RobustTokenizer.block(s5));
    }

    public static String or(String s1, String s2, String s3, String s4, String s5, String s6) {
        return RobustTokenizer.block(RobustTokenizer.block(s1) + "|" + RobustTokenizer.block(s2) + "|" + RobustTokenizer.block(s3) + "|" + RobustTokenizer.block(s4) + "|" + RobustTokenizer.block(s5) + "|" + RobustTokenizer.block(s6));
    }

    public static String or(String s1, String s2, String s3, String s4, String s5, String s6, String s7) {
        return RobustTokenizer.block(RobustTokenizer.block(s1) + "|" + RobustTokenizer.block(s2) + "|" + RobustTokenizer.block(s3) + "|" + RobustTokenizer.block(s4) + "|" + RobustTokenizer.block(s5) + "|" + RobustTokenizer.block(s6) + "|" + RobustTokenizer.block(s7));
    }

    public static String or(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8) {
        return RobustTokenizer.block(RobustTokenizer.block(s1) + "|" + RobustTokenizer.block(s2) + "|" + RobustTokenizer.block(s3) + "|" + RobustTokenizer.block(s4) + "|" + RobustTokenizer.block(s5) + "|" + RobustTokenizer.block(s6) + "|" + RobustTokenizer.block(s7) + "|" + RobustTokenizer.block(s8));
    }

    public static String or(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8, String s9) {
        return RobustTokenizer.block(RobustTokenizer.block(s1) + "|" + RobustTokenizer.block(s2) + "|" + RobustTokenizer.block(s3) + "|" + RobustTokenizer.block(s4) + "|" + RobustTokenizer.block(s5) + "|" + RobustTokenizer.block(s6) + "|" + RobustTokenizer.block(s7) + "|" + RobustTokenizer.block(s8) + "|" + RobustTokenizer.block(s9));
    }

    public static String or(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8, String s9, String s10) {
        return RobustTokenizer.block(RobustTokenizer.block(s1) + "|" + RobustTokenizer.block(s2) + "|" + RobustTokenizer.block(s3) + "|" + RobustTokenizer.block(s4) + "|" + RobustTokenizer.block(s5) + "|" + RobustTokenizer.block(s6) + "|" + RobustTokenizer.block(s7) + "|" + RobustTokenizer.block(s8) + "|" + RobustTokenizer.block(s9) + "|" + RobustTokenizer.block(s10));
    }

    public static String or(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8, String s9, String s10, String s11) {
        return RobustTokenizer.block(RobustTokenizer.block(s1) + "|" + RobustTokenizer.block(s2) + "|" + RobustTokenizer.block(s3) + "|" + RobustTokenizer.block(s4) + "|" + RobustTokenizer.block(s5) + "|" + RobustTokenizer.block(s6) + "|" + RobustTokenizer.block(s7) + "|" + RobustTokenizer.block(s8) + "|" + RobustTokenizer.block(s9) + "|" + RobustTokenizer.block(s10) + "|" + RobustTokenizer.block(s11));
    }

    public static String or(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8, String s9, String s10, String s11, String s12) {
        return RobustTokenizer.block(RobustTokenizer.block(s1) + "|" + RobustTokenizer.block(s2) + "|" + RobustTokenizer.block(s3) + "|" + RobustTokenizer.block(s4) + "|" + RobustTokenizer.block(s5) + "|" + RobustTokenizer.block(s6) + "|" + RobustTokenizer.block(s7) + "|" + RobustTokenizer.block(s8) + "|" + RobustTokenizer.block(s9) + "|" + RobustTokenizer.block(s10) + "|" + RobustTokenizer.block(s11) + "|" + RobustTokenizer.block(s12));
    }

    public static String rangeNot(String s) {
        return RobustTokenizer.range(RobustTokenizer.block("^" + s));
    }

    private static int hasApostropheBlock(String s) {
        for (int i = s.length() - 1; i > 0; --i) {
            if (s.charAt(i) == '\'' && i < s.length() - 1) {
                return i;
            }
            if (Character.isLetter(s.charAt(i))) continue;
            return -1;
        }
        return -1;
    }

    private static <T extends WordToken> String concatenate(List<T> tokens, int start, int end) {
        StringBuffer buffer = new StringBuffer();
        while (start < end) {
            buffer.append(((WordToken)tokens.get(start)).getWord());
            ++start;
        }
        return buffer.toString();
    }

    private static <T extends WordToken> int countNewLines(List<T> tokens, int start, int end) {
        int count = 0;
        for (int i = start + 1; i < end; ++i) {
            count += ((WordToken)tokens.get(i)).getNewLineCount();
        }
        return count;
    }

    public static boolean isUrl(String s) {
        Matcher match = urlPattern.matcher(s);
        return match.find(0);
    }

    public static boolean isEmail(String s) {
        Matcher match = emailPattern.matcher(s);
        return match.find(0);
    }

    public static boolean isSgml(String s) {
        Matcher match = sgmlPattern.matcher(s);
        return match.find(0);
    }

    public static boolean isSlashDate(String s) {
        Matcher match = slashDatePattern.matcher(s);
        return match.find(0);
    }

    public static boolean isAcronym(String s) {
        Matcher match = acronymPattern.matcher(s);
        return match.find(0);
    }

    public static boolean isDigitSeq(String s) {
        Matcher match = digitSeqPattern.matcher(s);
        return match.find(0);
    }

    public int countNewLines(String s, int start, int end) {
        int count = 0;
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) != '\n') continue;
            ++count;
        }
        return count;
    }

    public Word[] tokenizeToWords() {
        List<WordToken> toks = this.tokenizeToWordTokens();
        Word[] labels = new Word[toks.size()];
        for (int i = 0; i < toks.size(); ++i) {
            Word l;
            WordToken tok = toks.get(i);
            labels[i] = l = new Word(tok.getWord(), tok.getStart(), tok.getEnd());
        }
        return labels;
    }

    public List<WordToken> tokenizeToWordTokens() {
        ArrayList<WordToken> result = new ArrayList<WordToken>();
        Matcher match = wordPattern.matcher(this.buffer);
        int previousEndMatch = 0;
        while (match.find()) {
            WordToken token1;
            String crtMatch = match.group();
            int endMatch = match.end();
            int startMatch = endMatch - crtMatch.length();
            if (crtMatch.endsWith("n't")) {
                if (crtMatch.length() > 3) {
                    token1 = new WordToken(crtMatch.substring(0, crtMatch.length() - 3), startMatch, endMatch - 3, this.countNewLines(this.buffer, previousEndMatch, startMatch));
                    result.add(token1);
                }
                WordToken token2 = new WordToken(crtMatch.substring(crtMatch.length() - 3, crtMatch.length()), endMatch - 3, endMatch, 0);
                result.add(token2);
            } else {
                int i = RobustTokenizer.hasApostropheBlock(crtMatch);
                if (i != -1) {
                    token1 = new WordToken(crtMatch.substring(0, i), startMatch, startMatch + i, this.countNewLines(this.buffer, previousEndMatch, startMatch));
                    WordToken token2 = new WordToken(crtMatch.substring(i, crtMatch.length()), startMatch + i, endMatch, 0);
                    result.add(token1);
                    result.add(token2);
                } else {
                    WordToken token = new WordToken(crtMatch, startMatch, endMatch, this.countNewLines(this.buffer, previousEndMatch, startMatch));
                    result.add(token);
                }
            }
            previousEndMatch = endMatch;
        }
        List<WordToken> resultWithAbs = new ArrayList<WordToken>();
        for (int i = 0; i < result.size(); ++i) {
            int end = result.size();
            if (end > i + 20) {
                end = i + 20;
            }
            boolean found = false;
            while (end > i + 1) {
                WordToken startToken = (WordToken)result.get(i);
                WordToken endToken = (WordToken)result.get(end - 1);
                if (RobustTokenizer.countNewLines(result, i, end) == 0) {
                    String conc = RobustTokenizer.concatenate(result, i, end);
                    found = false;
                    if (this.mAbbreviations.contains(conc)) {
                        found = true;
                        WordToken token = new WordToken(conc, startToken.getStart(), endToken.getEnd(), startToken.getNewLineCount());
                        resultWithAbs.add(token);
                        i = end - 1;
                        break;
                    }
                }
                --end;
            }
            if (found) continue;
            resultWithAbs.add((WordToken)result.get(i));
        }
        resultWithAbs = this.postprocess(resultWithAbs);
        return resultWithAbs;
    }

    protected List<WordToken> postprocess(List<WordToken> tokens) {
        return tokens;
    }

    public String tokenizeText() throws IOException {
        List<WordToken> tokenList = this.tokenizeToWordTokens();
        StringBuffer strBuffer = new StringBuffer();
        Iterator<WordToken> iter = tokenList.iterator();
        if (iter.hasNext()) {
            strBuffer.append(iter.next());
        }
        while (iter.hasNext()) {
            strBuffer.append(" ");
            strBuffer.append(iter.next());
        }
        return strBuffer.toString().replaceAll("\\s\\s+", " ");
    }

    @Override
    protected Word getNext() {
        if (this.cachedTokens == null) {
            this.cachedTokens = this.tokenizeToWords();
            this.cachedPosition = 0;
        }
        if (this.cachedPosition >= this.cachedTokens.length) {
            return null;
        }
        Word token = this.cachedTokens[this.cachedPosition];
        ++this.cachedPosition;
        return token;
    }

    public static void main(String[] argv) throws Exception {
        int ch;
        if (argv.length != 1) {
            System.err.println("Usage: java edu.stanford.nlp.ie.machinereading.common.RobustTokenizer <file to tokenize>");
            System.exit(1);
        }
        BufferedReader is = new BufferedReader(new FileReader(argv[0]));
        StringBuffer buffer = new StringBuffer();
        while ((ch = is.read()) != -1) {
            buffer.append((char)ch);
        }
        RobustTokenizer t = new RobustTokenizer(buffer.toString());
        List tokens = t.tokenize();
        for (int i = 0; i < tokens.size(); ++i) {
            System.out.println(tokens.get(i));
        }
    }

    public static class WordToken {
        protected int mStart;
        protected int mEnd;
        protected int mNewLineCount;
        protected String mWord;

        public WordToken(String w, int s, int e) {
            this.mWord = w;
            this.mStart = s;
            this.mEnd = e;
            this.mNewLineCount = 0;
        }

        public WordToken(String w, int s, int e, int nl) {
            this.mWord = w;
            this.mStart = s;
            this.mEnd = e;
            this.mNewLineCount = nl;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[");
            buffer.append(this.mWord);
            buffer.append(", ");
            buffer.append(this.mStart);
            buffer.append(", ");
            buffer.append(this.mEnd);
            buffer.append("]");
            return buffer.toString();
        }

        public int getStart() {
            return this.mStart;
        }

        public void setStart(int i) {
            this.mStart = i;
        }

        public int getEnd() {
            return this.mEnd;
        }

        public void setEnd(int i) {
            this.mEnd = i;
        }

        public int getNewLineCount() {
            return this.mNewLineCount;
        }

        public void setNewLineCount(int i) {
            this.mNewLineCount = i;
        }

        public String getWord() {
            return this.mWord;
        }

        public void setWord(String w) {
            this.mWord = w;
        }
    }

    public static class AbbreviationMap {
        private Set<String> mAbbrevSet;

        private static List<String> normalizeCase(boolean caseInsensitive, List<String> words) {
            if (!caseInsensitive) {
                return words;
            }
            ArrayList<String> normWords = new ArrayList<String>();
            for (String word : words) {
                normWords.add(word.toLowerCase());
            }
            return normWords;
        }

        public AbbreviationMap(boolean caseInsensitive) {
            this.mAbbrevSet = Generics.newHashSet(AbbreviationMap.normalizeCase(caseInsensitive, Arrays.asList("1.", "10.", "11.", "12.", "13.", "14.", "15.", "16.", "17.", "18.", "19.", "2.", "20.", "21.", "22.", "23.", "24.", "25.", "26.", "27.", "28.", "29.", "3.", "30.", "31.", "32.", "33.", "34.", "35.", "36.", "37.", "38.", "39.", "4.", "40.", "41.", "42.", "43.", "44.", "45.", "46.", "47.", "48.", "49.", "5.", "50.", "6.", "7.", "8.", "9.", "A.", "A.C.", "A.D.", "A.D.L.", "A.F.", "A.G.", "A.H.", "A.J.C.", "A.L.", "A.M", "A.M.", "A.P.", "A.T.B.", "AUG.", "Act.", "Adm.", "Ala.", "Ariz.", "Ark.", "Assn.", "Ass'n.", "Ass'n", "Aug.", "B.", "B.A.T", "B.B.", "B.F.", "B.J.", "B.V.", "Bancorp.", "Bhd.", "Blvd.", "Br.", "Brig.", "Bros.", "C.", "C.B.", "C.D.s", "C.J.", "C.O.", "C.R.", "C.W.", "CEO.", "CO.", "CORP.", "COS.", "Cal.", "Calif.", "Capt.", "Cie.", "Cir.", "Cmdr.", "Co.", "Col.", "Colo.", "Comdr.", "Conn.", "Corp.", "Cos.", "D.", "D.B.", "D.C", "D.C.", "D.H.", "D.M.", "D.N.", "D.S.", "D.T", "D.T.", "D.s", "Dec.", "Del.", "Dept.", "Dev.", "Dr.", "Ds.", "E.", "E.E.", "E.F.", "E.I.", "E.M.", "E.R.", "E.W.", "Etc.", "F.", "F.A.", "F.A.O.", "F.C", "F.E.", "F.J.", "F.S.B.", "F.W.", "FEB.", "FL.", "Feb.", "Fed.", "Fla.", "Fran.", "French.", "Freon.", "Ft.", "G.", "G.D.", "G.L.", "G.O.", "G.S.", "G.m.b", "G.m.b.H.", "GP.", "GPO.", "Ga.", "Gen.", "Gov.", "H.", "H.F.", "H.G.", "H.H.", "H.J.", "H.L.", "H.R.", "Hon.", "I.", "I.B.M.", "I.C.H.", "I.E.P.", "I.M.", "I.V.", "I.W.", "II.", "III.", "INC.", "Intl.", "Int'l", "IV.", "IX.", "Ill.", "Inc.", "Ind.", "J.", "J.C.", "J.D.", "J.E.", "J.F.", "J.F.K.", "J.H.", "J.L.", "J.M.", "JohnQ.Public", "J.P.", "J.R.", "J.V", "J.V.", "J.X.", "Jan.", "Jansz.", "Je.", "Jos.", "Jr.", "K.", "K.C.", "Kan.", "Ky.", "L.", "L.A.", "L.H.", "L.J.", "L.L.", "L.M.", "L.P", "L.P.", "La.", "Lt.", "Ltd.", "M.", "M.A.", "M.B.A.", "M.D", "M.D.", "M.D.C.", "M.E.", "M.J.", "M.R.", "M.S.", "M.W.", "M8.7sp", "Maj.", "Mar.", "Mass.", "Md.", "Med.", "Messrs.", "Mfg.", "Mich.", "Minn.", "Mir.", "Miss.", "Mo.", "Mr.", "Mrs.", "Ms.", "Mt.", "N.", "N.A.", "N.C", "N.C.", "N.D", "N.D.", "N.H", "N.H.", "N.J", "N.J.", "N.M", "N.M.", "N.V", "N.V.", "N.Y", "N.Y.", "NOV.", "Neb.", "Nev.", "No.", "no.", "Nos.", "Nov.", "O.", "O.P.", "OK.", "Oct.", "Okla.", "Ore.", "P.", "P.J.", "P.M", "P.M.", "P.R.", "Pa.", "Penn.", "Pfc.", "Ph.", "Ph.D.", "pro-U.N.", "Prof.", "Prop.", "Pty.", "Q.", "R.", "R.D.", "Ret.", "R.H.", "R.I", "R.I.", "R.L.", "R.P.", "R.R.", "R.W.", "RLV.", "Rd.", "Rep.", "Reps.", "Rev.", "S.", "S.A", "S.A.", "S.C", "S.C.", "S.D.", "S.G.", "S.I.", "S.P.", "S.S.", "S.p", "S.p.A", "S.p.A.", "SKr1.5", "Sen.", "Sens.", "Sept.", "Sgt.", "Snr.", "Spc.", "Sr.", "St.", "Sys.", "T.", "T.D.", "T.F.", "T.T.", "T.V.", "TEL.", "Tech.", "Tenn.", "Tex.", "Tx.", "U.", "U.Cal-Davis", "U.K", "U.K.", "U.N.", "U.S.", "U.S.A", "U.S.A.", "U.S.C.", "U.S.C..", "U.S.S.R", "U.S.S.R.", "UK.", "US116.7", "V.", "V.H.", "VI.", "VII.", "VIII.", "VS.", "Va.", "Vs.", "Vt.", "W.", "W.A.", "W.G.", "W.I.", "W.J.", "W.R.", "W.T.", "W.Va", "W.Va.", "Wash.", "Wis.", "Wyo.", "X.", "Y.", "Y.J.", "Z.", "a.", "a.d.", "a.k.a", "a.m", "a.m.", "al.", "b.", "c.", "c.i.f", "cf.", "cnsl.", "cnsls.", "cont'd.", "d.", "deft.", "defts.", "e.", "et.", "etc.", "etseq.", "f.", "f.o.b", "ft.", "g.", "h.", "i.", "i.e.", "j.", "k.", "l.", "m.", "mots.", "n.", "o.", "p.", "p.m", "p.m.", "pltf.", "pltfs.", "prelim.", "r.", "s.", "seq.", "supp.", "sq.", "t.", "u.", "v.", "vs.", "x.", "y.", "z.")));
        }

        public boolean contains(String s) {
            return this.mAbbrevSet.contains(s.toLowerCase());
        }
    }
}

