theory question_14_9

imports Main

begin

typedecl entity
typedecl event

consts
  Male :: "entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Event :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Action :: "event ⇒ action ⇒ bool"
  ThumbOut :: "entity ⇒ bool"
  BrownClothing :: "entity ⇒ bool"
  SideOfStreet :: "entity ⇒ bool"
  BigBag :: "entity ⇒ bool"
  Standing :: "entity ⇒ bool"

(* Premise: ∃x. Male(x) ∧ BrownClothing(x) ∧ Standing(x) ∧ SideOfStreet(x) ∧ ThumbOut(x) ∧ BigBag(x) *)
assumes asm: "Male x ∧ BrownClothing x ∧ Standing x ∧ SideOfStreet x ∧ ThumbOut x ∧ BigBag x"

(* Hypothesis: ∃x. Man(x) ∧ Standing(x) *)
shows "∃x. Man x ∧ Standing x"

proof -
  from asm have "Male x" "BrownClothing x" "Standing x" "SideOfStreet x" "ThumbOut x" "BigBag x" by auto
  then have "Event (Standing x)" using explanation_2 by blast
  then have "Event (Man_standing_with_thumb_out x)" using explanation_3 by blast
  then have "Man x" using explanation_3 by blast
  then show ?thesis using asm by blast
qed

end
