theory question_26_2
imports Main

begin
typedecl entity
typedecl event

consts
  Directing :: "entity ⇒ entity ⇒ bool"
  Crowd :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  Pedestrian :: "entity ⇒ bool"
  Policeman :: "entity ⇒ bool"
  Herding :: "event ⇒ entity ⇒ entity ⇒ bool"
  Walking :: "entity ⇒ bool"

(* Explanation 1: Directing a crowd of people implies that the crowd is composed of pedestrians. *)
axiomatization where
  explanation_1: "∀x z. Directing x z ∧ Crowd z ∧ People z ⟶ Pedestrian z"

(* Explanation 2: Directing a crowd of people is another expression of herding pedestrians. *)
axiomatization where
  explanation_2: "∀x y z e. Policeman x ∧ Crowd z ∧ People z ∧ Directing x z ⟷ Herding e x y"

theorem hypothesis:
  (* Premise: A policeman is directing a crowd of people walking. *)
  assumes asm: "Policeman x ∧ Crowd z ∧ People z ∧ Walking z ∧ Directing e x z ∧ Agent e x ∧ Patient e z"
  (* Hypothesis: A policeman is herding pedestrians. *)
  shows "∃x y e. Policeman x ∧ Pedestrian y ∧ Herding e x y ∧ Agent e x ∧ Patient e y"
proof -
  {
    assume "Directing x z ∧ Crowd z ∧ People z"
    then have "Pedestrian z" using explanation_1 by blast
  }
  then obtain y where "Pedestrian y ∧ Crowd y ∧ People y" using asm by blast
  then have "Policeman x ∧ Directing x y ∧ Crowd y ∧ People y" using asm by blast
  then have "Herding e x y" using explanation_2 by blast
  then show ?thesis using asm `Policeman x` `Pedestrian y` `Herding e x y` by blast
qed

end
